
package com.clustercontrol.ws.cloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>cloudUserTypeのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="cloudUserType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="account"/>
 *     &lt;enumeration value="user"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "cloudUserType")
@XmlEnum
public enum CloudUserType {

    @XmlEnumValue("account")
    ACCOUNT("account"),
    @XmlEnumValue("user")
    USER("user");
    private final String value;

    CloudUserType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static CloudUserType fromValue(String v) {
        for (CloudUserType c: CloudUserType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
