/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CreateAccountResourceRequest;
import com.clustercontrol.cloud.presenter.CreateCloudUserRequest;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.cloud.ui.dialogs.CreateAccountResourceDialog;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;

public class CreateAccountResourceAction
extends AbstractViewAction {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateAccountResourceAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgCreateAccountResourceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.account_resource", "word.create"});
    private String msgCreateAccountResourceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.account_resource", "word.create"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        CreateAccountResourceDialog dialog = new CreateAccountResourceDialog(this.viewPart.getSite().getShell());
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateAccountResourceConfirm)) {
                CreateAccountResourceDialog.DialogOutput output = dialog.getOutput();
                IAccountResourceManager manager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager();
                CreateAccountResourceRequest createAccountResourceRequest = new CreateAccountResourceRequest();
                ControlUtil.importObject(createAccountResourceRequest, output);
                CreateCloudUserRequest createCloudUserRequest = new CreateCloudUserRequest();
                ControlUtil.importObject(createCloudUserRequest, output);
                createCloudUserRequest.setDescription(output.getCloudUserDescription());
                createAccountResourceRequest.setDescription(output.getAccountResourceDescription());
                manager.createAccountResource(createAccountResourceRequest, createCloudUserRequest);
                FacilityTree.refresh();
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateAccountResourceResult);
            } else {
                return;
            }
        }
    }
}

