/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.INode;
import com.clustercontrol.cloud.presenter.IScope;
import com.clustercontrol.cloud.ui.views.FilterlingViewPart;
import com.clustercontrol.cloud.ui.views.IAROrientedView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;

public abstract class FilterlingViewPartByScopeAndAnother<R extends IElement, E extends IElement, M>
extends FilterlingViewPart<IAccountResource.IRegion, R, E, M>
implements ISelectionListener,
IAROrientedView {
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private List<String> elementIds;
    private IAccountResource currentAccountResource;
    private IAccountResource nextAccountResource;
    protected Map<IAccountResource.IRegion, String> resultMap = new HashMap<IAccountResource.IRegion, String>();

    @Override
    protected boolean prepareFilterConditiion(String viweId, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        if (viweId.equals("com.clustercontrol.cloud.ui.views.ScopeView")) {
            IStructuredSelection sselection = (IStructuredSelection)selection;
            if (sselection.isEmpty()) {
                this.setNextState(null);
                return true;
            }
            IAccountResource accountResource = null;
            Object selected = sselection.getFirstElement();
            if (selected instanceof IScope) {
                IScope scope = (IScope)selected;
                switch (scope.getScopeType()) {
                    case region: {
                        accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(scope));
                        this.setNextState(accountResource != null ? accountResource.getRegion(IScope.ScopeType.region.getRegion(scope)) : null);
                        break;
                    }
                    case zone: {
                        accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(scope.getParent()));
                        this.setNextState(accountResource != null ? accountResource.getRegion(IScope.ScopeType.region.getRegion(scope.getParent())) : null);
                        break;
                    }
                    case root: {
                        this.setNextState(null);
                        break;
                    }
                    case account_resource_scope: {
                        accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.account_resource_scope.getAccountResourceId(scope));
                        this.setNextState(null);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else if (selected instanceof INode) {
                INode node = (INode)selected;
                accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(IScope.ScopeType.region.getAccountResourceId(node.getParent().getParent()));
                this.setNextState(accountResource.getRegion(IScope.ScopeType.region.getRegion(node.getParent().getParent())));
            }
            this.nextAccountResource = accountResource;
            if (this.nextAccountResource != null) {
                try {
                    if (!AccountControlUtil.isInitializedActiveUser(this.nextAccountResource.getAccountResourceId()).booleanValue()) {
                        AccountControlUtil.selectActiveUser(this.getSite().getPage().findView("com.clustercontrol.cloud.ui.views.ScopeView"));
                    }
                }
                catch (AccountControlUtil.NotFoundAccountResourceException e) {
                    throw new IllegalStateException();
                }
            }
            return true;
        }
        if (viweId.equals(this.getSupportViewId())) {
            IStructuredSelection sselection = (IStructuredSelection)selection;
            if (sselection.isEmpty()) {
                this.elementIds = Collections.emptyList();
            } else {
                this.elementIds = new ArrayList<String>();
                for (Object selected : sselection) {
                    String elementId = this.getElementId(selected);
                    if (elementId == null) continue;
                    this.elementIds.add(elementId);
                }
            }
            this.releaseElements();
            this.addElements();
        }
        return false;
    }

    protected abstract String getHeaderByElementId(IAccountResource.IRegion var1, List<String> var2);

    protected String getHeaderByRegion(IAccountResource.IRegion region) {
        return this.bundle_messages.getString("word.region") + this.bundle_messages.getString("caption.title_separator") + region.getRegionName();
    }

    protected String getEmptyHeader() {
        return "";
    }

    protected abstract String getElementId(Object var1);

    @Override
    protected boolean isMatch(E element) {
        return this.getCurrentState() != null && this.isMatchRegion((IAccountResource.IRegion)this.getCurrentState(), element) && this.isMatchElementIds(this.elementIds, element);
    }

    protected abstract boolean isMatchRegion(IAccountResource.IRegion var1, E var2);

    protected abstract boolean isMatchElementIds(List<String> var1, E var2);

    protected abstract Label getHeaderLabel();

    protected abstract String getSupportViewId();

    protected abstract Label getLeftFooter();

    protected abstract Label getRightFooter();

    @Override
    protected void failedPrepareFilterConditiion(Exception exception) {
        super.failedPrepareFilterConditiion(exception);
        this.getHeaderLabel().setText("");
        if (exception instanceof CloudModelException) {
            this.getLeftFooter().setText(((CloudModelException)exception).getMessage());
        } else {
            this.getLeftFooter().setText(this.bundle_messages.getString("word.fail"));
        }
        this.getRightFooter().setText(this.bundle_messages.getString("word.view_item_count") + this.bundle_messages.getString("caption.title_separator") + this.getCurrentElements().size());
    }

    @Override
    protected void successGetManagerData(IAccountResource.IRegion targetState, List<M> managerElements) {
        super.successGetManagerData(targetState, managerElements);
        this.resultMap.put(targetState, this.bundle_messages.getString("word.success"));
    }

    @Override
    protected void failedGetManagerData(IAccountResource.IRegion targetState, Exception exception) {
        super.failedGetManagerData(targetState, exception);
        this.resultMap.put(targetState, this.bundle_messages.getString("word.fail"));
    }

    @Override
    protected void startGetManagerData(IAccountResource.IRegion region) {
        this.getLeftFooter().setText(this.bundle_messages.getString("caption.accessing_to", new String[]{region.getRegionName()}));
    }

    @Override
    protected void nextState() {
        IAccountResource oldAccountResource = this.currentAccountResource;
        if (this.getCurrentState() != this.getNextState()) {
            this.elementIds = Collections.emptyList();
        }
        super.nextState();
        this.currentAccountResource = this.nextAccountResource;
        if (oldAccountResource != this.currentAccountResource) {
            this.firePropertyChange(0);
        }
    }

    @Override
    protected void updateStatus() {
        if (this.getCurrentState() != null) {
            if (!this.elementIds.isEmpty()) {
                this.getHeaderLabel().setText(this.getHeaderByElementId((IAccountResource.IRegion)this.getCurrentState(), this.elementIds));
            } else {
                this.getHeaderLabel().setText(this.getHeaderByRegion((IAccountResource.IRegion)this.getCurrentState()));
            }
        } else {
            this.getHeaderLabel().setText(this.getEmptyHeader());
        }
        this.getLeftFooter().setText(this.resultMap.get(this.getCurrentState()) == null ? "" : this.resultMap.get(this.getCurrentState()));
        this.getRightFooter().setText(this.bundle_messages.getString("word.view_item_count") + this.bundle_messages.getString("caption.title_separator") + this.getCurrentElements().size());
    }

    @Override
    protected void updateStatus(Exception exception) {
        if (this.getCurrentState() != null) {
            if (!this.elementIds.isEmpty()) {
                this.getHeaderLabel().setText(this.getHeaderByElementId((IAccountResource.IRegion)this.getCurrentState(), this.elementIds));
            } else {
                this.getHeaderLabel().setText(this.getHeaderByRegion((IAccountResource.IRegion)this.getCurrentState()));
            }
        } else {
            this.getHeaderLabel().setText(this.getEmptyHeader());
        }
        this.getLeftFooter().setText(this.resultMap.get(this.getCurrentState()) == null ? "" : this.resultMap.get(this.getCurrentState()));
        this.getRightFooter().setText(this.bundle_messages.getString("word.view_item_count") + this.bundle_messages.getString("caption.title_separator") + this.getCurrentElements().size());
    }

    public IAccountResource.IRegion getActiveRegion() {
        return (IAccountResource.IRegion)this.getCurrentState();
    }

    @Override
    public void update() {
        ISelection selection = this.getSite().getPage().getSelection("com.clustercontrol.cloud.ui.views.ScopeView");
        this.update(new FilterlingViewPart.ConcreteDataHolder("com.clustercontrol.cloud.ui.views.ScopeView", selection), true);
    }

    @Override
    public IAccountResource getCurrentAccountResource() {
        return this.currentAccountResource;
    }
}

