/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.presenter.CloudResourceManager;
import com.clustercontrol.cloud.presenter.Facility;
import com.clustercontrol.cloud.presenter.FacilityRoot;
import com.clustercontrol.cloud.presenter.IScope;
import com.clustercontrol.cloud.presenter.Node;
import java.util.ArrayList;
import java.util.List;

public class Scope
extends Facility
implements IScope {
    private Scope parent;
    private IScope.ScopeType scopeType;
    private List<Scope> scopes = new ArrayList<Scope>();
    private List<Node> nodes = new ArrayList<Node>();

    @Override
    public Scope getParent() {
        return this.parent;
    }

    public void setParent(Scope parent) {
        this.parent = parent;
    }

    public Scope[] getScopes() {
        return this.scopes.toArray(new Scope[0]);
    }

    public void addChildScope(Scope child) {
        if (!this.scopes.contains(child)) {
            this.scopes.add(child);
            this.fireElementAdded(IScope.p2.scopes, child);
        }
    }

    public void removeChildScope(Scope child) {
        if (this.scopes.contains(child)) {
            this.scopes.remove(child);
            this.fireElementRemoved(IScope.p2.scopes, child);
        }
    }

    public Node[] getNodes() {
        return this.nodes.toArray(new Node[0]);
    }

    public void addChildNode(Node child) {
        if (!this.nodes.contains(child)) {
            this.nodes.add(child);
            this.fireElementAdded(IScope.p2.nodes, child);
        }
    }

    public void removeChildNode(Node child) {
        if (this.nodes.contains(child)) {
            this.nodes.remove(child);
            this.fireElementRemoved(IScope.p2.nodes, child);
        }
    }

    @Override
    public FacilityRoot getFacilityRoot() {
        return this.parent.getFacilityRoot();
    }

    public CloudResourceManager getCloudResourceManager() {
        return this.getFacilityRoot().getCloudResourceManager();
    }

    @Override
    public IScope.ScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(IScope.ScopeType type) {
        this.scopeType = type;
    }

    @Override
    public String getAccountResourceId() {
        return this.getScopeType().getAccountResourceId(this);
    }

    @Override
    public String getRegion() {
        return this.getScopeType().getRegion(this);
    }
}

