/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.IntegerLimit;
import com.clustercontrol.cloud.commons.util.annotation.RelationalRequiredInput;
import com.clustercontrol.util.Messages;
//import com.clustercontrol.cloud.commons.util.annotation.Export;
//import com.clustercontrol.cloud.commons.util.annotation.IntegerLimit;

public class BillingDetailCollectSettingDialog extends Dialog {
		
	public interface IDialogBehavior{
		void setupRetentionPeriod(Text txtRetentionPeriod);
		void setupBillingDetailCollectorFlg(Button btnBillingDetailCollectorFlg);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		@Override
		public void setupRetentionPeriod(Text txtRetentionPeriod){
			
		}
		@Override
		public void setupBillingDetailCollectorFlg(Button btnBillingDetailCollectorFlg){
			
		}
	}
	
	public static class DialogOutput{
		private Integer retentionPeriod;
		private Boolean billingDetailCollectorFlg;
		public Integer getRetentionPeriod() {
			return retentionPeriod;
		}
		public void setRetentionPeriod(Integer retentionPeriod) {
			this.retentionPeriod = retentionPeriod;
		}
		public Boolean getBillingDetailCollectorFlg() {
			return billingDetailCollectorFlg;
		}
		public void setBillingDetailCollectorFlg(
				Boolean billingDetailCollectorFlg) {
			this.billingDetailCollectorFlg = billingDetailCollectorFlg;
		}
	}
	
	private DialogOutput output = new DialogOutput();
	
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private String strSeparator = bundle_messages.getString("caption.title_separator");
	private String strRetentionPeriod = bundle_messages.getString("word.retention_period");
	private String strDays = bundle_messages.getString("word.days");
	private String strEnableBillingDetailCollection = bundle_messages.getString("caption.enable_billing_detail_collection");
	
	
	@RelationalRequiredInput(name = "btnBillingDetailCollectorFlg", value = "strRetentionPeriod")
	@IntegerLimit("strRetentionPeriod")
	private Text txtRetentionPeriod;
	private Button btnBillingDetailCollectorFlg;
	
	private IDialogBehavior behavior = new DialogBehavior();

	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public BillingDetailCollectSettingDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		GridLayout gridLayout = (GridLayout) area.getLayout();
		gridLayout.numColumns = 2;
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		gl_container.verticalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.horizontalSpan = 2;
		gd_container.widthHint = 345;
		container.setLayoutData(gd_container);
		
		{

			Composite cmpBillingDetailCollectorFlg = new Composite(container, SWT.NONE);
			GridLayout gl_billingDetailCollectorFlg = new GridLayout(2, false);
			cmpBillingDetailCollectorFlg.setLayout(gl_billingDetailCollectorFlg);
			GridData gd_cmpBillingDetailCollectorFlg = new GridData(SWT.FILL, SWT.FILL, true, true);
			gd_cmpBillingDetailCollectorFlg.horizontalSpan = 2;
			cmpBillingDetailCollectorFlg.setLayoutData(gd_cmpBillingDetailCollectorFlg);
			btnBillingDetailCollectorFlg = new Button(cmpBillingDetailCollectorFlg, SWT.CHECK);
			btnBillingDetailCollectorFlg.setText(strEnableBillingDetailCollection);
			btnBillingDetailCollectorFlg.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true));
			new Label(cmpBillingDetailCollectorFlg, SWT.NONE);
		}
		
		//初期化ブロック1
		{
			btnBillingDetailCollectorFlg.addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e) {
					if(btnBillingDetailCollectorFlg.getSelection()){
						txtRetentionPeriod.setEnabled(true);
						if(txtRetentionPeriod != null && txtRetentionPeriod.getEnabled() && txtRetentionPeriod.getEditable() && txtRetentionPeriod.getText().isEmpty()){
							txtRetentionPeriod.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
						} else if(txtRetentionPeriod != null) {
							txtRetentionPeriod.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
						}
					} else {
						txtRetentionPeriod.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
						txtRetentionPeriod.setEnabled(false);
					}
				}
			});
		}
		
		{
			behavior.setupBillingDetailCollectorFlg(btnBillingDetailCollectorFlg);
		}
		new Label(area, SWT.NONE);
		Composite cmpRetentionPeriod = new Composite(area, SWT.NONE);
		GridData gd_cmpRetentionPeriod = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_cmpRetentionPeriod.widthHint = 230;
		cmpRetentionPeriod.setLayoutData(gd_cmpRetentionPeriod);
		GridLayout gl_retentionPeriod = new GridLayout(3, false);
		cmpRetentionPeriod.setLayout(gl_retentionPeriod);
		Label lblRetentionPeriod = new Label(cmpRetentionPeriod, SWT.NONE);
		lblRetentionPeriod.setText(strRetentionPeriod + strSeparator);
		lblRetentionPeriod.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true));
		txtRetentionPeriod = new Text(cmpRetentionPeriod, SWT.BORDER);
		txtRetentionPeriod.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		Label lblDays = new Label(cmpRetentionPeriod, SWT.NONE);
		lblDays.setText(strDays);
		lblDays.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		behavior.setupRetentionPeriod(txtRetentionPeriod);
		
		//初期化ブロック2
		{
			if(!btnBillingDetailCollectorFlg.getSelection()){
				txtRetentionPeriod.setEnabled(false);
			}
		}

		ControlUtil.setRequired(new Control[]{txtRetentionPeriod});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(399, 220);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}
		
		{
			output.setRetentionPeriod(Integer.valueOf(txtRetentionPeriod.getText()));
			output.setBillingDetailCollectorFlg(btnBillingDetailCollectorFlg.getSelection());
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_messages.getString("caption.billing_detail_collect_setting_dialog"));
	}

	public DialogOutput getOutput() {
		return output;
	}

	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}
}
