/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import java.io.IOException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Combo;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.views.StoragesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;


public class CreateStorageAction extends AbstractViewAction {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgCreateStorageConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.create"});
	private String msgCreateStorageResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.create"});


	@Override
	public void invoke(IAction action) throws InvocationException {

		final StoragesView view = (StoragesView)viewPart;
		IRegion region = view.getActiveRegion();
		
		if (region == null) {
			assert view.getCurrentAccountResource().getRegions().length > 0;
			region = view.getCurrentAccountResource().getRegions()[0];
		}
		
		final CloudResourceProvider provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
		CreateStorageDialog dialog = new CreateStorageDialog(this.viewPart.getSite().getShell());
		
		dialog.setCloudInfoProvider(provider);
		
		dialog.setBehavior(new CreateStorageDialog.DialogBehavior(){
			@Override
			public void setupRegion(Combo cmbRegion) {
				super.setupRegion(cmbRegion);
				
				if (view != null && view.getActiveRegion() != null && cmbRegion.indexOf(view.getActiveRegion().getRegionName()) != -1) {
					cmbRegion.select(cmbRegion.indexOf(view.getActiveRegion().getRegionName()));
				} else if(cmbRegion.getItemCount() > 0) {
					cmbRegion.select(0);
				}
			}
		});
		
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateStorageConfirm)){

				CreateStorageDialog.DialogData output = dialog.getOutput();
				
				CreateStorageDialog.StorageDetail detail = new CreateStorageDialog.StorageDetail();
				
				detail.iops = output.getIops();
				
				ObjectMapper om = new ObjectMapper();
				ObjectWriter dw = om.writerWithType(CreateStorageDialog.StorageDetail.class);
				String storageDetail = null;
				try {
					storageDetail = dw.writeValueAsString(detail);
				} catch (IOException e) {
					throw new InvocationException(e);
				}

				output.setStorageDetail(storageDetail);
				
				region.getAccountResource().getRegion(output.getRegion()).getCloudService(ICloudComputeService.class).getStorageManager().createCloudStorage(output);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateStorageResult);
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		action.setEnabled(true);
	}

}