/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.presenter.BlockDeviceMapping;
import com.clustercontrol.cloud.presenter.ICloudInstanceManager;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.PropertyId2;
import com.clustercontrol.cloud.presenter.RegistNodeRequest;
import com.clustercontrol.cloud.presenter.RunJobRequest;
import com.clustercontrol.cloud.presenter.ValueObserver2;
import com.clustercontrol.cloud.resources.Tag;
import java.util.List;

public interface ICloudInstance
extends IElement {
    public String getFacilityId();

    public String getFacilityName();

    public String getInstanceId();

    public String getInstanceName();

    public String getPlatform();

    public String getCloudTypeId();

    public String getRegion();

    public String getZone();

    public String getPublicDnsName();

    public String getState();

    public String getRegistState();

    public String getType();

    public Long getRegDate();

    public String getRegUser();

    public Long getUpdateDate();

    public String getUpdateUser();

    public String getFlavor();

    public String getImageId();

    public String getTemplateId();

    public String getCloudUserId();

    public List<Tag> getTags();

    public List<BlockDeviceMapping> getBlockDeviceMappings();

    public ICloudInstanceManager getCloudInstanceManager();

    public void start();

    public void stop();

    public void attachStorage(String var1, String var2);

    public void detachStorage(String var1);

    public void registNode(RegistNodeRequest var1);

    public void start(RunJobRequest var1);

    public void stop(RunJobRequest var1);

    public void establishAgentConnection();

    public static enum RegistStateType {
        registered(0),
        unregistered(1),
        deleted(2);

        private short num;

        private RegistStateType(short num) {
            this.num = num;
        }

        public short number() {
            return this.num;
        }

        public static RegistStateType byNumber(short num) {
            for (RegistStateType type : RegistStateType.values()) {
                if (type.number() != num) continue;
                return type;
            }
            return null;
        }
    }

    public static enum StateType {
        pending("pending"),
        running("running"),
        shutting_down("shutting-down"),
        terminated("terminated"),
        stopping("stopping"),
        stopped("stopped"),
        rebooting("rebooting");

        private final String label;

        private StateType(String label) {
            this.label = label;
        }

        public String label() {
            return this.label;
        }

        public static StateType byLabel(String label) {
            String name = label.replace('-', '_');
            return StateType.valueOf(name);
        }
    }

    public static interface p2 {
        public static final PropertyId2<ValueObserver2<String>> facilityId = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> facilityName = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> instanceId = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> instanceName = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> platform = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> cloudTypeId = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> region = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> zone = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> publicDnsName = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> state = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> registState = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> type = new PropertyId2();
        public static final PropertyId2<ValueObserver2<Long>> regDate = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> regUser = new PropertyId2();
        public static final PropertyId2<ValueObserver2<Long>> updateDate = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> updateUser = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> cloudUserId = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> flavor = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> imageId = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> templateId = new PropertyId2();
        public static final PropertyId2<ValueObserver2<List<BlockDeviceMapping>>> blockDeviceMappings = new PropertyId2();
        public static final PropertyId2<ValueObserver2<List<Tag>>> tags = new PropertyId2();
        public static final PropertyId2<ValueObserver2<String>> detail = new PropertyId2();
    }
}

