/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import com.clustercontrol.cloud.aws.base.Activator;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.ui.dialogs.ShowWindowsPasswordDialog;
import com.clustercontrol.cloud.commons.util.KeyCodec;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.aws.AWSOptionEndpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;

public class GetWindowsPassAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strPrivateKeyFile = this.messages.getString("caption.private_key_file");
    private String msgPrivateKeyFileDifferent = this.messages.getString("message.private_key_file_different");
    private String msgGetWindowsPassConfirm = this.messages.getString("message.confirm_that_perform_some_action", new Object[]{"caption.get_password"});

    protected boolean canEnabled(IStructuredSelection selection) {
        ICloudInstance instance = (ICloudInstance)selection.getFirstElement();
        return "WINDOWS".equals(instance.getPlatform());
    }

    protected void invoke(IAction action) throws InvocationException {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgGetWindowsPassConfirm)) {
            AWSOptionEndpoint endpoint = Activator.getEndpointManager().getEndpoint(AWSOptionEndpoint.class);
            String password = null;
            try {
                password = endpoint.getWindowsPassword(instance.getCloudInstanceManager().getRegion().getAccountResource().getActiveUser().getRoleId(), instance.getRegion(), instance.getInstanceId());
            }
            catch (Exception e) {
                throw new InvocationException((Throwable)e);
            }
            FileDialog dialog = new FileDialog(this.viewPart.getSite().getShell());
            String[] exts = new String[]{"*.pem"};
            String[] filterNames = new String[]{this.strPrivateKeyFile + "(" + "*.pem" + ")"};
            dialog.setFilterExtensions(exts);
            dialog.setFilterNames(filterNames);
            String file = dialog.open();
            if (file == null) {
                return;
            }
            try {
                KeyCodec codec = new KeyCodec();
                codec.setPrivateKeyFile(file);
                String decryptedPassword = new String(codec.decryptWithPrivateKey(KeyCodec.getBase64Binary((String)password)));
                if (decryptedPassword == null || decryptedPassword.isEmpty()) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgPrivateKeyFileDifferent);
                    return;
                }
                ShowWindowsPasswordDialog swpDialog = new ShowWindowsPasswordDialog(this.viewPart.getSite().getShell());
                swpDialog.setText(decryptedPassword);
                swpDialog.open();
            }
            catch (Exception e) {
                throw new InvocationException((Throwable)e);
            }
        }
    }
}

