/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class AttachStorageFromStorageDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strZone = this.messages.getString("word.zone");
    private String strInstance = this.messages.getString("word.instance");
    private String strStorageType = this.messages.getString("word.storage_type");
    private String strVolumeSize = this.messages.getString("word.volume_size");
    private String strSnapshot = this.messages.getString("word.snapshot");
    private String strDevice = this.messages.getString("word.device");
    private String strStorageId = this.messages.getString("word.storage_id");
    private String strSnapshotId = this.messages.getString("word.snapshot_id");
    private String strSize = this.messages.getString("size");
    private String strAttachStorageDialog = this.messages.getString("caption.attach_storage_dialog");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private Text zone;
    private Combo comboInstance;
    private Table tblVolume;
    private TableViewer tableViewer;
    private Text device;
    private ICloudStorage storage;
    private String instanceId;
    private String deviceName;

    public AttachStorageFromStorageDialog(Shell parentShell, ICloudStorage storage) {
        super(parentShell);
        this.storage = storage;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    protected Control createDialogArea(Composite parent) {
        this.storage.update();
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(5, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblZone = new Label(container, 0);
        lblZone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblZone.setText(this.strZone + this.strSeparator);
        this.zone = new Text(container, 8);
        this.zone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.zone.setText(this.storage.getZone());
        new Label(container, 0);
        new Label(container, 0);
        Label lblInstance = new Label(container, 0);
        lblInstance.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstance.setText(this.strInstance + this.strSeparator);
        this.comboInstance = new Combo(container, 8);
        this.comboInstance.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ICloudInstance instance = (ICloudInstance)AttachStorageFromStorageDialog.this.comboInstance.getData(AttachStorageFromStorageDialog.this.comboInstance.getText());
                AttachStorageFromStorageDialog.this.instanceId = instance.getInstanceId();
                ArrayList<ICloudStorage> storages = new ArrayList<ICloudStorage>();
                for (ICloudStorage s : AttachStorageFromStorageDialog.this.storage.getCloudStorageManager().getCloudStorages()) {
                    if (!AttachStorageFromStorageDialog.this.instanceId.equals(s.getStorageAttachment() == null ? null : s.getStorageAttachment().getInstanceId())) continue;
                    storages.add(s);
                }
            }
        });
        GridData gd_instance = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_instance.widthHint = 199;
        this.comboInstance.setLayoutData((Object)gd_instance);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblVolumeType = new Label(container, 0);
        lblVolumeType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVolumeType.setText(this.strStorageType + this.strSeparator);
        Text volumeType = new Text(container, 8);
        GridData gd_volumeType = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_volumeType.widthHint = 226;
        volumeType.setLayoutData((Object)gd_volumeType);
        volumeType.setText(this.messages.getString(this.storage.getFlavor().toString()));
        Label lblVolumeSize = new Label(container, 0);
        GridData gd_lblVolumeSize = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblVolumeSize.widthHint = 83;
        lblVolumeSize.setLayoutData((Object)gd_lblVolumeSize);
        lblVolumeSize.setText(this.strVolumeSize + this.strSeparator);
        Text volumeSize = new Text(container, 8);
        GridData gd_volumeSize = new GridData(16384, 131072, false, false, 1, 1);
        gd_volumeSize.widthHint = 134;
        volumeSize.setLayoutData((Object)gd_volumeSize);
        volumeSize.setText(this.storage.getSize().toString());
        Label lblGib = new Label(container, 0);
        GridData gd_lblGib = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblGib.widthHint = 55;
        lblGib.setLayoutData((Object)gd_lblGib);
        lblGib.setText("GiB");
        Label lblSnapshot = new Label(container, 0);
        lblSnapshot.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSnapshot.setText(this.strSnapshot + this.strSeparator);
        Combo snapshot = new Combo(container, 0);
        snapshot.setEnabled(false);
        snapshot.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        snapshot.setText(this.storage.getSnapshotId());
        Label lblDevice = new Label(container, 0);
        lblDevice.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDevice.setText(this.strDevice);
        this.device = new Text(container, 2048);
        GridData gd_device = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_device.widthHint = 242;
        this.device.setLayoutData((Object)gd_device);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.tblVolume = new Table(container, 0x10010800);
        this.tblVolume.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
            }
        });
        this.tblVolume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachStorageFromStorageDialog.this.tblVolume.select(-1);
            }
        });
        this.tblVolume.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.tblVolume.setHeaderVisible(true);
        this.tblVolume.setLinesVisible(true);
        TableColumn tblclmnType = new TableColumn(this.tblVolume, 0);
        tblclmnType.setWidth(100);
        tblclmnType.setText(this.strStorageId);
        TableColumn tblclmnDevice = new TableColumn(this.tblVolume, 0);
        tblclmnDevice.setWidth(100);
        tblclmnDevice.setText(this.strDevice);
        TableColumn tblclmnSnapshotId = new TableColumn(this.tblVolume, 0);
        tblclmnSnapshotId.setWidth(100);
        tblclmnSnapshotId.setText(this.strSnapshotId);
        TableColumn tblclmnSize = new TableColumn(this.tblVolume, 0);
        tblclmnSize.setWidth(100);
        tblclmnSize.setText(this.strSize);
        TableColumn tblclmnVolumeType = new TableColumn(this.tblVolume, 0);
        tblclmnVolumeType.setWidth(100);
        tblclmnVolumeType.setText(this.strStorageType);
        this.tableViewer = new TableViewer(this.tblVolume);
        VolumeProvider vp = new VolumeProvider();
        this.tableViewer.setContentProvider((IContentProvider)vp.getVolumeContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)vp.getVolumeLabelProvider());
        this.storage.getCloudStorageManager().getCloudComputeService().getInstanceManager().update();
        for (ICloudInstance instance : this.storage.getCloudStorageManager().getCloudComputeService().getInstanceManager().getCloudInstances()) {
            if (!instance.getZone().equals(this.storage.getZone()) || instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name())) continue;
            this.comboInstance.setData(instance.getInstanceId(), (Object)instance);
            this.comboInstance.add(instance.getInstanceId());
        }
        if (this.comboInstance.getItemCount() > 0) {
            this.comboInstance.select(0);
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    protected void okPressed() {
        if (this.instanceId == null || "".equals(this.device.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        this.deviceName = this.device.getText();
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strAttachStorageDialog);
    }

    public static class VolumeProvider {
        private VolumeContentProvider vcp = new VolumeContentProvider();
        private VolumeLabelProvider vlp = new VolumeLabelProvider();

        public VolumeContentProvider getVolumeContentProvider() {
            return this.vcp;
        }

        public VolumeLabelProvider getVolumeLabelProvider() {
            return this.vlp;
        }

        public class VolumeLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getColumnText(Object element, int columnIndex) {
                ICloudStorage storage = (ICloudStorage)element;
                switch (columnIndex) {
                    case 0: {
                        return storage.getStorageId();
                    }
                    case 1: {
                        return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
                    }
                    case 2: {
                        return storage.getSnapshotId() != null ? storage.getSnapshotId() : "";
                    }
                    case 3: {
                        return storage.getSize() != null ? String.valueOf(storage.getSize()) : "";
                    }
                    case 4: {
                        return storage.getFlavor();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        }

        public class VolumeContentProvider
        implements IStructuredContentProvider {
            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

