/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.presenter;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.cloud.aws.base.presenter.IEndpointManager;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.ws.aws.AWSOptionEndpoint;
import com.clustercontrol.ws.aws.AWSOptionEndpointService;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudEndpointService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPBinding;
import org.eclipse.jface.preference.IPreferenceStore;

public class EndpointManager
implements IEndpointManager {
    private static final ThreadLocal<CloudEndpoint> cloudEndpoint = new ThreadLocal<CloudEndpoint>(){

        @Override
        protected CloudEndpoint initialValue() {
            InvocationHandler h = new InvocationHandler(){
                private String currentUserId;
                private String currentPassword;
                private String currentUrl;
                private CloudEndpoint endpoint;

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String userId;
                    if (this.endpoint == null) {
                        userId = LoginManager.getUserId();
                        String password = LoginManager.getPassword();
                        String url = LoginManager.getUrl();
                        if (!(userId == null || userId.isEmpty() || password == null || password.isEmpty() || url == null || url.isEmpty())) {
                            this.endpoint = EndpointManager.createCloudEndpoint(userId, password, url);
                            this.currentUserId = userId;
                            this.currentPassword = password;
                            this.currentUrl = url;
                        }
                    } else {
                        userId = LoginManager.getUserId();
                        String password = LoginManager.getPassword();
                        String url = LoginManager.getUrl();
                        if (!(this.currentUserId.equals(userId) && this.currentPassword.equals(password) && this.currentUrl.equals(url))) {
                            this.endpoint = EndpointManager.createCloudEndpoint(userId, password, url);
                            this.currentUserId = userId;
                            this.currentPassword = password;
                            this.currentUrl = url;
                        }
                    }
                    try {
                        return method.invoke((Object)this.endpoint, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
            };
            return (CloudEndpoint)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CloudEndpoint.class}, h);
        }
    };
    private static final ThreadLocal<AWSOptionEndpoint> awsOptionEndpoint = new ThreadLocal<AWSOptionEndpoint>(){

        @Override
        protected AWSOptionEndpoint initialValue() {
            InvocationHandler h = new InvocationHandler(){
                private String currentUserId;
                private String currentPassword;
                private String currentUrl;
                private AWSOptionEndpoint endpoint;

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String userId;
                    if (this.endpoint == null) {
                        userId = LoginManager.getUserId();
                        String password = LoginManager.getPassword();
                        String url = LoginManager.getUrl();
                        if (!(userId == null || userId.isEmpty() || password == null || password.isEmpty() || url == null || url.isEmpty())) {
                            this.endpoint = EndpointManager.createAWSOptionEndpoint(userId, password, url);
                            this.currentUserId = userId;
                            this.currentPassword = password;
                            this.currentUrl = url;
                        }
                    } else {
                        userId = LoginManager.getUserId();
                        String password = LoginManager.getPassword();
                        String url = LoginManager.getUrl();
                        if (!(this.currentUserId.equals(userId) && this.currentPassword.equals(password) && this.currentUrl.equals(url))) {
                            this.endpoint = EndpointManager.createAWSOptionEndpoint(userId, password, url);
                            this.currentUserId = userId;
                            this.currentPassword = password;
                            this.currentUrl = url;
                        }
                    }
                    try {
                        return method.invoke((Object)this.endpoint, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
            };
            return (AWSOptionEndpoint)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{AWSOptionEndpoint.class}, h);
        }
    };

    @Override
    public synchronized <T> T getEndpoint(Class<T> clazz) {
        CloudEndpoint endpoint = null;
        if (clazz == CloudEndpoint.class) {
            endpoint = cloudEndpoint.get();
        }
        if (clazz == AWSOptionEndpoint.class) {
            endpoint = awsOptionEndpoint.get();
        }
        return (T)endpoint;
    }

    private static CloudEndpoint createCloudEndpoint(String userId, String password, String url) {
        CloudEndpoint endpoint = null;
        try {
            String urlCloudEndpoint = LoginManager.getUrl() + CloudEndpointService.class.getSimpleName();
            CloudEndpointService service = new CloudEndpointService(new URL(urlCloudEndpoint + "?wsdl"), new QName("http://cloud.ws.clustercontrol.com", CloudEndpointService.class.getSimpleName()));
            endpoint = service.getCloudEndpointPort();
            BindingProvider bp = (BindingProvider)endpoint;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", urlCloudEndpoint);
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", userId);
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", password);
            IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
            int httpConnectTimeout = store.getInt("httpConnectTimeout");
            int httpRequestTimeout = store.getInt("httpRequestTimeout");
            bp.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", httpConnectTimeout * 1000);
            bp.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", httpRequestTimeout * 1000);
            ((SOAPBinding)bp.getBinding()).setMTOMEnabled(true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return endpoint;
    }

    private static AWSOptionEndpoint createAWSOptionEndpoint(String userId, String password, String url) {
        AWSOptionEndpoint endpoint = null;
        try {
            String urlAWSOptionEndpoint = LoginManager.getUrl() + AWSOptionEndpointService.class.getSimpleName();
            AWSOptionEndpointService service = new AWSOptionEndpointService(new URL(urlAWSOptionEndpoint + "?wsdl"), new QName("http://aws.ws.clustercontrol.com", AWSOptionEndpointService.class.getSimpleName()));
            endpoint = service.getAWSOptionEndpointPort();
            BindingProvider bp = (BindingProvider)endpoint;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", urlAWSOptionEndpoint);
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", userId);
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", password);
            IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
            int httpConnectTimeout = store.getInt("httpConnectTimeout");
            int httpRequestTimeout = store.getInt("httpRequestTimeout");
            bp.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", httpConnectTimeout * 1000);
            bp.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", httpRequestTimeout * 1000);
            ((SOAPBinding)bp.getBinding()).setMTOMEnabled(true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return endpoint;
    }

    @Override
    public String getAccountName() {
        return LoginManager.getUserId();
    }
}

