/*

 Copyright (C) 2012 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import com.clustercontrol.notify.session.NotifyControllerBean;
import com.clustercontrol.snmptrap.bean.SnmpTrapV1;

/**
 * snmptrap監視の通知実装のインタフェース(シングル版)
 */
public class SnmpTrapNotifier {

	private static final Log m_log = LogFactory.getLog(SnmpTrapNotifier.class);

	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";

	public static final int _messageMaxLength = 255;

	public static String replaceUnsafeCharacter(String str) {

		String charList = HinemosProperties.getProperty("common.notify.replace.before", "0");
		char newChar = HinemosProperties.getProperty("common.notify.replace.after", "?").charAt(0);

		for (String oldCharByte : charList.split(",")) {
			int oldCharInt = Integer.parseInt(oldCharByte);
			Character oldChar = (char)oldCharInt;
			if (str != null) {
				str = str.replace(oldChar, newChar);
			}
		}

		return str;
	}

	public void put(SnmpTrapV1 snmptrap, String monitorId, String notifyGroupId, int priority,
			String facilityId, String facilityPath, String application, String msg, String msgOrig) {

		OutputBasicInfo info = new OutputBasicInfo();

		info.setMonitorId(monitorId);
		info.setPluginId(HinemosModuleConstant.MONITOR_SNMPTRAP);
		info.setSubKey(snmptrap.enterpriseId + "_" + snmptrap.genericId + "_" + snmptrap.specificId);
		info.setPriority(priority);

		info.setApplication(application);
		info.setFacilityId(facilityId);
		info.setScopeText(facilityPath);
		info.setGenerationDate(snmptrap.receivedTime);

		msg = replaceUnsafeCharacter(msg);
		msgOrig = replaceUnsafeCharacter(msgOrig);

		if (priority == PriorityConstant.TYPE_INFO) {
			info.setMessageId(MESSAGE_ID_INFO);
		} else if (priority == PriorityConstant.TYPE_WARNING) {
			info.setMessageId(MESSAGE_ID_WARNING);
		} else if (priority == PriorityConstant.TYPE_CRITICAL) {
			info.setMessageId(MESSAGE_ID_CRITICAL);
		} else {
			info.setMessageId(MESSAGE_ID_UNKNOWN);
		}

		if (msg.length() > _messageMaxLength) {
			info.setMessage(msg.substring(0, _messageMaxLength));
		} else {
			info.setMessage(msg);
		}

		info.setMessageOrg(msgOrig);

		try {
			new NotifyControllerBean().notify(info, notifyGroupId);
		} catch (Exception e) {
		}

	}

}
