package com.clustercontrol.snmptrap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.entity.SnmpTrapMibMasterPK;
import com.clustercontrol.snmptrap.model.SnmpTrapMibMstEntity;

/**
 * SNMPTRAP監視のキャッシュ
 *
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class SnmpTrapMibMasterCache {
	private static Log m_log = LogFactory.getLog( SnmpTrapMibMasterCache.class );

	private static Object lock = new Object();
	private static ConcurrentHashMap<SnmpTrapMibMasterPK, SnmpTrapMibMasterData> trapMibMstCache
	= new ConcurrentHashMap<SnmpTrapMibMasterPK, SnmpTrapMibMasterData>();

	static {
		refresh();
	}

	/**
	 * キャッシュのリフレッシュ
	 * このメソッドはsynchronizedの内部で呼ぶこと。
	 */
	private static void refresh(){
		JpaTransactionManager jtm = new JpaTransactionManager();
		if (!jtm.isNestedEm()) {
			jtm.close();
			m_log.warn("refresh() : transactioin has not been begined.");
			return;
		}

		if (trapMibMstCache.isEmpty()) {
			long start = System.currentTimeMillis();
			try {
				List<SnmpTrapMibMstEntity> c = QueryUtil.getAllSnmpTrapMibMst();

				for(SnmpTrapMibMstEntity entity : c){
					m_log.debug("refresh SnmpTrapMibMasterCache " +
							"mib=" + entity.getMib() +
							", orderNo=" + entity.getOrderNo() +
							", description=" + entity.getDescription() +
							", regDate=" + entity.getRegDate() +
							", updateDate=" + entity.getUpdateDate() +
							", regUser=" + entity.getRegUser() +
							", updateUser=" + entity.getUpdateUser());
					SnmpTrapMibMasterData mibData =
							new SnmpTrapMibMasterData(
									entity.getMib(),
									entity.getOrderNo(),
									entity.getDescription(),
									entity.getRegDate() == null ? 0 : entity.getRegDate().getTime(),
											entity.getUpdateDate() == null ? 0 : entity.getUpdateDate().getTime(),
													entity.getRegUser(),
													entity.getUpdateUser());
					SnmpTrapMibMasterPK mibDataPk = new SnmpTrapMibMasterPK(entity.getMib());
					trapMibMstCache.put(mibDataPk, mibData);
				}
			} catch (Exception e) {
				m_log.warn("refresh() : "
						+ e.getClass().getSimpleName() + ", " + e.getMessage(), e);
			}
			m_log.info("refresh SnmpTrapMibMasterCache. " + (System.currentTimeMillis() - start) +
					"ms. size=" + trapMibMstCache.size());
		}
	}

	public static void clear() {
		synchronized (lock) {
			trapMibMstCache.clear();
		}
	}

	public static SnmpTrapMibMasterData getMibMasterInfo(String mib) throws MonitorNotFound {
		synchronized(lock) {
			refresh();
			for(SnmpTrapMibMasterPK pk : trapMibMstCache.keySet()){
				if(mib.equals(pk.mib)){
					return trapMibMstCache.get(pk);
				}
			}
			MonitorNotFound e = new MonitorNotFound("mib = " + mib);
			m_log.info("getMibMasterInfo() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
	}

	public static ArrayList<String> getMibList(){
		synchronized(lock) {
			refresh();
			ArrayList<SnmpTrapMibMasterData> tmpList = new ArrayList<SnmpTrapMibMasterData>();
			for(SnmpTrapMibMasterPK pk : trapMibMstCache.keySet()) {
				tmpList.add(trapMibMstCache.get(pk));
			}
			Collections.sort(tmpList, new Comparator<SnmpTrapMibMasterData>() {
				@Override
				public int compare(SnmpTrapMibMasterData o1, SnmpTrapMibMasterData o2) {
					int comp = 0;
					comp = o1.getOrderNo().compareTo(o2.getOrderNo());
					if (comp != 0) {
						return comp;
					}
					comp = o1.getMib().compareTo(o2.getMib());
					if (comp != 0) {
						return comp;
					}
					return 0;
				}
			});
			ArrayList<String> mibList = new ArrayList<String>();
			for (SnmpTrapMibMasterData d : tmpList) {
				mibList.add(d.getMib());
			}
			return mibList;
		}
	}
}
