/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.selfcheck.monitor;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.bean.ThreadInfo;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * スレッドの活動状況を確認する処理の実装クラス
 * @author takahatat
 */
public class ThreadActivityMonitor extends SelfCheckMonitorBase {

	private static Log log = LogFactory.getLog( ThreadActivityMonitor.class );

	public final ThreadInfo threadInfo;
	public final int thresholdSec;

	public final String monitorId = "SYS_THREAD";
	public final String subKey;
	public final String application = "SELFCHECK (Thread)";

	/**
	 * コンストラクタ
	 * @param threadInfo スレッド情報
	 * @param thresholdSec 最大処理時間(この時間より長く実行されている場合、停滞スレッドと判定する)
	 */
	public ThreadActivityMonitor(ThreadInfo threadInfo, int thresholdSec) {
		this.threadInfo = threadInfo;
		this.thresholdSec = thresholdSec;

		this.subKey = threadInfo.threadName;
	}

	@Override
	public String toString() {
		return String.format("monitoring thread (threadInfo = %s, threshold = %s)", threadInfo, thresholdSec + ")");
	}

	@Override
	public String getMonitorId() {
		return monitorId;
	}

	@Override
	public String getSubKey() {
		return subKey;
	}

	@Override
	public void execute() {
		/** ローカル変数 */
		Date now = null;
		String startTimeStr = null;

		boolean warn = true;

		/** メイン処理 */
		log.debug("monitoring thread. (threadInfo = " + threadInfo + ")");

		now = new Date();
		startTimeStr =  String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", new Date(threadInfo.taskStartTime));

		if (now.getTime() - threadInfo.taskStartTime <= thresholdSec * 1000) {
			log.info("thread is active : " + threadInfo);

			warn = false;
		}

		if (warn) {
			log.info("thread takes long time : " + threadInfo);
		}
		if (!isNotify(warn)) {
			return;
		}
		String[] msgAttr1 = { new Long(threadInfo.tid).toString(), threadInfo.threadName, threadInfo.taskClassName, startTimeStr };
		AplLogger aplLogger = new AplLogger(PLUGIN_ID, APL_ID);
		aplLogger.put(MESSAGE_ID, "012", msgAttr1,
				"internal logic (tid " +
						threadInfo.tid +
						", thread name " +
						threadInfo.threadName +
						", class name " +
						threadInfo.taskClassName +
						", start time " +
						startTimeStr +
						") takes more than " +
						thresholdSec +
				" [sec].");

		return;
	}



}
