package com.clustercontrol.process.factory;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.process.entity.MonitorProcessPollingMstData;
import com.clustercontrol.process.entity.MonitorProcessPollingMstPK;
import com.clustercontrol.process.model.MonitorProcessPollingMstEntity;
import com.clustercontrol.process.util.QueryUtil;

/**
 * プロセス監視のキャッシュ
 *
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class ProcessMasterCache {
	private static Log m_log = LogFactory.getLog( ProcessMasterCache.class );

	private static ConcurrentHashMap<MonitorProcessPollingMstPK, MonitorProcessPollingMstData> monitorProcessPollingMstCache =
			new ConcurrentHashMap<MonitorProcessPollingMstPK, MonitorProcessPollingMstData>();

	static {
		JpaTransactionManager jtm = new JpaTransactionManager();
		if (!jtm.isNestedEm()) {
			m_log.warn("refresh() : transactioin has not been begined.");
			jtm.close();
		} else {
	
			try {
				List<MonitorProcessPollingMstEntity> c = QueryUtil.getAllMonitorProcessPollingMst();
	
				for (MonitorProcessPollingMstEntity entity : c) {
					MonitorProcessPollingMstData data =
							new MonitorProcessPollingMstData(
									entity.getId().getCollectMethod(),
									entity.getId().getPlatformId(),
									entity.getId().getSubPlatformId(),
									entity.getId().getVariableId(),
									entity.getEntryKey(),
									entity.getPollingTarget());
					MonitorProcessPollingMstPK dataPk = new MonitorProcessPollingMstPK(
							entity.getId().getCollectMethod(),
							entity.getId().getPlatformId(),
							entity.getId().getSubPlatformId(),
							entity.getId().getVariableId());
					monitorProcessPollingMstCache.put(dataPk, data);
				}
			} catch (Exception e) {
				m_log.warn("ProcessMasterCache() : "
						+ e.getClass().getSimpleName() + ", " + e.getMessage(), e);
			}
		}
	}
	public static MonitorProcessPollingMstData getMonitorProcessPollingMst (MonitorProcessPollingMstPK pk) {
		return monitorProcessPollingMstCache.get(pk);
	}
}
