/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.repository.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.util.NodePropertyUtil;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.NodeInfo;

/**
 * 登録ノードのリストを取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeList {

	// ログ
	private static Log m_log = LogFactory.getLog( GetNodeList.class );

	// ----- instance メソッド ----- //

	/**
	 * 全てのノード一覧を取得します。
	 * 
	 * @return ノード一覧
	 */
	public List<NodeInfo> getAll() {

		List<NodeInfo> records = null;
		try {
			records = RepositoryEndpointWrapper.getNodeListAll();
		} catch (InvalidRole_Exception e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (Exception e) {
			m_log.warn("getAll(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
		return records;
	}

	/**
	 * propertyの条件にヒットするノードの一覧を返します。
	 * 
	 * @param property
	 * @return ノード一覧
	 */
	public List<NodeInfo> get(Property property) {
		PropertyUtil.deletePropertyDefine(property);

		List<NodeInfo> records = null;
		try {
			NodeInfo nodeInfo = null;
			nodeInfo = NodePropertyUtil.property2node(property);
			records = RepositoryEndpointWrapper.getFilterNodeList(nodeInfo);
		} catch (InvalidRole_Exception e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (Exception e) {
			m_log.warn("get(), " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}
		return records;
	}
}