/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view.action;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.monitor.composite.StatusListComposite;
import com.clustercontrol.monitor.util.ConvertListUtil;
import com.clustercontrol.monitor.util.MonitorEndpointWrapper;
import com.clustercontrol.monitor.view.StatusView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.StatusDataInfo;

/**
 * 監視[ステータス]ビューの削除アクションによるステータスの削除処理を行うクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class StatusDeleteAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( StatusDeleteAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.StatusDeleteAction";

	/** ビュー */
	private IViewPart viewPart;


	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	/**
	 * 監視[ステータス]ビューの選択されたアイテムを削除し、ビューを更新します。
	 * <p>
	 * <ol>
	 * <li>監視[ステータス]ビューで、選択されているアイテムを取得します。</li>
	 * <li>取得したステータス情報を削除します。 </li>
	 * <li>監視[ステータス]ビューを更新します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.monitor.view.StatusView
	 * @see com.clustercontrol.monitor.view.StatusView#update()
	 */
	@Override
	public void run(IAction action) {
		// 選択アイテムを取得します。
		StatusView view = (StatusView) this.viewPart.getAdapter(StatusView.class);

		StatusListComposite composite = (StatusListComposite) view
				.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite
				.getTableViewer().getSelection();

		List list = selection.toList();

		// 選択しているステータス情報を削除して、再描画します。
		if (list != null) {
			ArrayList<StatusDataInfo> statusList = ConvertListUtil.listToStatusInfoDataList(list);

			if (statusList != null && statusList.size()>0) {
				try {
					MonitorEndpointWrapper.deleteStatus(statusList);
					view.update();
				} catch (InvalidRole_Exception e) {
					// アクセス権なしの場合、エラーダイアログを表示する
					MessageDialog.openInformation(null, Messages.getString("message"),
							Messages.getString("message.accesscontrol.16"));
				} catch (MonitorNotFound_Exception e) {
					MessageDialog.openError(null, Messages.getString("message"),
							Messages.getString("message.monitor.61") + ", " + e.getMessage());
				} catch (HinemosUnknown_Exception e) {
					MessageDialog.openError(null, Messages.getString("message"),
							Messages.getString("message.monitor.61") + ", " + e.getMessage());
				} catch (Exception e) {
					m_log.warn("run(), " + e.getMessage(), e);
					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
				}
			}
		}
	}

	/**
	 * 選択を変更した際に呼ばれます。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}