/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.view.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.maintenance.composite.MaintenanceListComposite;
import com.clustercontrol.maintenance.util.MaintenanceEndpointWrapper;
import com.clustercontrol.maintenance.view.MaintenanceListView;
import com.clustercontrol.maintenance.action.GetMaintenanceListTableDefine;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.maintenance.InvalidRole_Exception;

/**
 * メンテナンス[一覧]ビューの削除アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class MaintenanceDeleteAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( MaintenanceDeleteAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.maintenance.view.action.MaintenanceDeleteAction";

	/** ビュー */
	private IViewPart viewPart;


	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		MaintenanceListView view = (MaintenanceListView) this.viewPart.getAdapter(MaintenanceListView.class);

		MaintenanceListComposite composite = (MaintenanceListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String maintenanceId = null;
		if(list != null && list.size() > 0){
			maintenanceId = (String) list.get(GetMaintenanceListTableDefine.MAINTENANCE_ID);
		}

		String[] args = { maintenanceId };

		// 選択アイテムがある場合に、削除処理を呼び出す
		if(maintenanceId != null){
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.maintenance.7", args))) {

				try {
					MaintenanceEndpointWrapper.deleteMaintenance(maintenanceId);
					MessageDialog.openInformation(
							null,
							Messages.getString("successful"),
							Messages.getString("message.maintenance.5", args));
					composite.update();
				} catch (InvalidRole_Exception e) {
					MessageDialog.openInformation(null, Messages.getString("message"),
							Messages.getString("message.accesscontrol.16"));
				} catch (Exception e) {
					m_log.warn("run(), " + e.getMessage(), e);
					MessageDialog.openError(
							null,
							Messages.getString("failed"),
							Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
				}
			}
		}
		else{
			MessageDialog.openWarning(
					null,
					Messages.getString("warning"),
					Messages.getString("message.maintenance.9"));
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
