/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.viewer;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import com.clustercontrol.ws.collectiverun.TreeItem;

/**
 * TreeViewerクラス用のViewerSorterクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TreeViewerSorter extends ViewerSorter {

	/**
	 * コンストラクタ
	 * 
	 * @param column
	 *            ソート対象カラムインデックス
	 */
	public TreeViewerSorter() {

	}

	/**
	 * 比較処理
	 * 
	 * @param viewer
	 * @param e1
	 * @param e2
	 * @return 比較結果。superクラスの結果をソートオーダーにより反転する
	 */
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		if (e1 instanceof TreeItem && e2 instanceof TreeItem) {
			Integer object1 = getOrderNumber((TreeItem)e1);
			Integer object2 = getOrderNumber((TreeItem)e2);

			int rtn = object1.compareTo(object2);

			return rtn;
		}
		return 0;
	}

	private Integer getOrderNumber(TreeItem item){
		if(item.getCommandInfo() != null){
			return new Integer(item.getCommandInfo().getOrderNo());
		}
		else if(item.getCommandParameterInfo() != null){
			return new Integer(item.getCommandParameterInfo().getOrderNo());
		}
		else if(item.getParameterInfo() != null){
			return new Integer(item.getParameterInfo().getOrderNo());
		}
		else if(item.getParameterSelectInfo() != null){
			return new Integer(item.getParameterSelectInfo().getOrderNo());
		}
		else if(item.getTypeInfo() != null){
			return new Integer(item.getTypeInfo().getOrderNo());
		}
		else{
			return null;
		}
	}
}