/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.bean.ParameterConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.ws.collectiverun.CollectiveRunInfo;
import com.clustercontrol.ws.collectiverun.CollectiveRunInfo.Param.Entry;
import com.clustercontrol.ws.collectiverun.CommandParameterInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;
import com.clustercontrol.ws.repository.FacilityTreeItem;

/**
 * 一括制御履歴実行情報のDTOとプロパティを相互変換するためのユーティリティクラスです。
 * @since 0.1
 */
public class RunPropertyUtil {

	// ログ
	private static Log m_log = LogFactory.getLog( RunPropertyUtil.class );

	/**
	 * プロパティを一括制御履歴フィルタ情報DTOに変換するメソッドです。
	 * 
	 * @param property
	 * @return 一括制御履歴フィルタ情報
	 * @throws RemoteException
	 */
	public static CollectiveRunInfo property2dto(String typeId, Property property) throws InvalidRole_Exception{
		CollectiveRunInfo info = new CollectiveRunInfo();
		ArrayList values = null;

		//ファシリティID（スコープ）取得
		values = PropertyUtil.getPropertyValue(property, ParameterConstant.SCOPE);
		String facilityId = null;
		if(values.get(0) instanceof FacilityTreeItem){
			facilityId = ((FacilityTreeItem)values.get(0)).getData().getFacilityId();
		}
		else if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
			facilityId = (String)values.get(0);
		}
		info.setFacilityId(facilityId);

		//名前取得
		values = PropertyUtil.getPropertyValue(property, ParameterConstant.NAME);
		String name = (String)values.get(0);
		info.setName(name);

		//名前からコマンドIDを取得
		String commandId = null;
		List<CommandParameterInfo> commandParameterList = null;

		try {
			commandId = CollectiveRunEndpointWrapper.getCommandId(typeId, name);
			commandParameterList = CollectiveRunEndpointWrapper.getCommandParameterMstList(commandId);
		} catch (InvalidRole_Exception e) {
			throw e;
		} catch (Exception e) {
			m_log.warn("property2dto() getCommandId, " + e.getMessage(), e);
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
		}

		//パラメータ値取得
		CollectiveRunInfo.Param infoParam = new CollectiveRunInfo.Param();
		List<Entry> entryList = infoParam.getEntry();
		for(CommandParameterInfo cmdParam : commandParameterList){
			values = PropertyUtil.getPropertyValue(property, cmdParam.getId());
			String value = null;
			if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
				value = (String)values.get(0);
			}
			Entry entry = new Entry();
			entry.setKey(cmdParam.getId());
			entry.setValue(value);
			entryList.add(entry);
		}
		info.setParam(infoParam);

		return info;
	}


}
