/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.composite;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.collectiverun.action.GetDetailTableDefine;
import com.clustercontrol.collectiverun.util.CollectiveRunEndpointWrapper;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.collectiverun.DetailInfo;
import com.clustercontrol.ws.collectiverun.InvalidRole_Exception;

/**
 * 一括制御[詳細]コンポジット
 * 
 * 
 * @version 1.0.0
 * @since 1.0.0
 * 
 */
public class DetailComposite extends Composite {

	// ログ
	private static Log m_log = LogFactory.getLog( DetailComposite.class );

	/** テーブルビューワ */
	private CommonTableViewer m_viewer = null;

	/** セッションID */
	private String m_sessionId = null;

	private Label m_sessionIdLabel = null;

	/**
	 * コンストラクタ
	 * 
	 * @param parent
	 * @param style
	 */
	public DetailComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
	}

	/**
	 * 初期化処理
	 * 
	 */
	private void initialize() {
		GridLayout layout = new GridLayout(1, true);
		this.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		//セッションIDラベル作成
		m_sessionIdLabel = new Label(this, SWT.LEFT);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		m_sessionIdLabel.setLayoutData(gridData);

		Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION | SWT.SINGLE);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		table.setLayoutData(gridData);

		m_viewer = new CommonTableViewer(table);
		m_viewer.createTableColumn(GetDetailTableDefine.get(),
				GetDetailTableDefine.SORT_COLUMN_INDEX,
				GetDetailTableDefine.SORT_ORDER);

		this.update(null);
	}

	/**
	 * 更新処理
	 * 
	 * @since 1.0.0
	 */
	public void update(String sessionId) {
		List<DetailInfo> list = null;

		//ジョブ詳細情報取得
		if (sessionId != null && sessionId.length() > 0) {
			try {
				list = CollectiveRunEndpointWrapper.getDetailList(sessionId);
			} catch (InvalidRole_Exception e) {
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			} catch (Exception e) {
				m_log.warn("update(), " + e.getMessage(), e);
				MessageDialog.openError(
						null,
						Messages.getString("failed"),
						Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
			}
		}
		if(list == null){
			list = new ArrayList<DetailInfo>();
		}
		ArrayList<Object> listInput = new ArrayList<Object>();
		for (DetailInfo info : list) {
			ArrayList<Object> obj = new ArrayList<Object>();
			obj.add(info.getStatus());
			obj.add(info.getEndStatus());
			obj.add(info.getEndValue());
			obj.add(info.getFacilityId());
			obj.add(info.getFacilityName());
			if (info.getStartDate() != null) {
				obj.add(new Date(info.getStartDate()));
			} else {
				obj.add("");
			}
			if (info.getEndDate() != null) {
				obj.add(new Date(info.getEndDate()));
			} else {
				obj.add("");
			}
			obj.add(info.getMessage());
			listInput.add(obj);
		}
		m_viewer.setInput(listInput);

		m_sessionId = sessionId;

		//セッションIDを表示
		if (m_sessionId != null) {
			m_sessionIdLabel.setText(Messages.getString("session.id") + " : "
					+ m_sessionId);
		} else {
			m_sessionIdLabel.setText(Messages.getString("session.id") + " : ");
		}
	}

	/**
	 * @return Returns the sessionId.
	 */
	public String getSessionId() {
		return m_sessionId;
	}

	/**
	 * @param sessionId
	 *            The sessionId to set.
	 */
	public void setSessionId(String sessionId) {
		m_sessionId = sessionId;
	}
}