package com.clustercontrol.accesscontrol.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.accesscontrol.bean.RoleIdConstant;
import com.clustercontrol.accesscontrol.bean.RoleSettingTreeConstant;
import com.clustercontrol.accesscontrol.composite.RoleSettingTreeComposite;
import com.clustercontrol.accesscontrol.composite.action.RoleSettingTreeSelectionChangedListener;
import com.clustercontrol.accesscontrol.view.action.RoleSettingAssignSystemPrivilegeAction;
import com.clustercontrol.accesscontrol.view.action.RoleSettingAssignUserAction;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.ws.access.RoleInfo;
import com.clustercontrol.ws.accesscontrol.RoleTreeItem;

/**
 * アカウント[ロール設定]ビュークラス<BR>
 * 
 * クライアントの画面を構成します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RoleSettingTreeView extends CommonViewPart {

	/** ビューID */
	public static final String ID = "com.clustercontrol.accesscontrol.view.RoleSettingTreeView";

	/** ツリー用コンポジット */
	private RoleSettingTreeComposite m_tree = null;
	/** ロールツリーアイテム */
	private RoleTreeItem m_copyTreeItem = null;

	/**
	 * コンストラクタ
	 */
	public RoleSettingTreeView() {
		super();
	}

	/**
	 * ビューを構築します。
	 * 
	 * @param parent 親コンポジット
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 * @see #createContextMenu()
	 * @see #update()
	 */
	@Override
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;

		//階層ツリー作成
		m_tree = new RoleSettingTreeComposite(this, parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_tree.setLayoutData(gridData);

		m_tree.getTreeViewer().addSelectionChangedListener(
				new RoleSettingTreeSelectionChangedListener(m_tree));

		//ポップアップメニュー作成
		createContextMenu();

		//ビューを更新
		this.update();
	}

	/**
	 * コンテキストメニューを作成します。
	 * 
	 * @see org.eclipse.jface.action.MenuManager
	 * @see org.eclipse.swt.widgets.Menu
	 */
	private void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			@Override
			public void menuAboutToShow(IMenuManager manager) {

				//メニュー項目設定
				fillContextMenu(manager);
			}
		});
		Menu treeMenu = menuManager.createContextMenu(m_tree.getTree());
		m_tree.getTree().setMenu(treeMenu);
	}

	/**
	 * コンテキストメニューに項目を追加します。
	 * 
	 * @param manager メニューマネージャ
	 * 
	 * @see org.eclipse.jface.action.IToolBarManager
	 * @see org.eclipse.jface.action.IMenuManager
	 */
	private void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar = this.getViewSite().getActionBars()
				.getToolBarManager();
		ActionContributionItem assignUserAction = (ActionContributionItem) toolbar
				.find(RoleSettingAssignUserAction.ID);
		ActionContributionItem assignSystemPrivilegeAction = (ActionContributionItem) toolbar
				.find(RoleSettingAssignSystemPrivilegeAction.ID);

		//ポップアップメニューにアクションを追加
		manager.add(assignUserAction.getAction());
		manager.add(assignSystemPrivilegeAction.getAction());
	}

	/**
	 * ビューを更新します。
	 * 
	 */
	public void update() {
		this.m_tree.update();
	}
	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param selectedInfo 現在選択中のロール・ユーザのRoleInfo/UserInfoを指定<br>
	 * 何も選択していない場合にはnullを指定する
	 * 
	 * @param selection ボタン（アクション）を有効にするための情報
	 * 
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public void setEnabledAction(Object selectedInfo, ISelection selection) {

		super.setEnabledAction(RoleSettingAssignUserAction.ID, selection);
		super.setEnabledAction(RoleSettingAssignSystemPrivilegeAction.ID, selection);

		if (selectedInfo instanceof RoleInfo
				&& !((RoleInfo)selectedInfo).getId().equals(RoleSettingTreeConstant.ROOT_ID)) {
			if (((RoleInfo)selectedInfo).getId().equals(RoleIdConstant.ADMINISTRATORS)) {
				// ADMINISTRATORSロール
				super.setEnabledAction(RoleSettingAssignUserAction.ID, true);
				super.setEnabledAction(RoleSettingAssignSystemPrivilegeAction.ID, false);
			} else if (((RoleInfo)selectedInfo).getId().equals(RoleIdConstant.ALL_USERS)) {
				// ALL_USERSロール
				super.setEnabledAction(RoleSettingAssignUserAction.ID, false);
				super.setEnabledAction(RoleSettingAssignSystemPrivilegeAction.ID, true);
			} else  {
				// 上記以外
				super.setEnabledAction(RoleSettingAssignUserAction.ID, true);
				super.setEnabledAction(RoleSettingAssignSystemPrivilegeAction.ID, true);
			}
		} else {
			super.setEnabledAction(RoleSettingAssignUserAction.ID, false);
			super.setEnabledAction(RoleSettingAssignSystemPrivilegeAction.ID, false);
		}

	}

	/**
	 * ロールツリー用のコンポジットを返します。
	 * 
	 * @return ロールツリー用のコンポジット
	 */
	public RoleSettingTreeComposite getTreeComposite() {
		return m_tree;
	}

	/**
	 * 選択ロールツリーアイテムを返します。
	 * 
	 * @return RoleTreeItem 選択されたロールツリーアイテム
	 */
	public RoleTreeItem getSelectJobTreeItem() {
		return m_tree.getSelectItem();
	}
}
