/*

Copyright (C) 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.util;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.repository.util.RepositoryEndpointWrapper;
import com.clustercontrol.util.LoginManager;
import com.sun.xml.internal.ws.client.ClientTransportException;

public class LocalSession {

	// ログ
	private static Log m_log = LogFactory.getLog( LoginManager.class );

	/** ファシリティID更新用タイマー * */
	private static Timer m_timer = null;

	/** リポジトリ最終更新時刻 */
	private static Date clientLastUpdate = null;

	/** マネージャへの疎通(Dummy)ポーリング周期（秒） */
	public static int m_managerPollingInterval = 1;

	/** 自分自身のインスタンス */
	private static LocalSession m_instance = null;

	private static boolean dialogFlag = true;

	/*:
	 * 
	 */
	public static LocalSession getLocalSession(){
		if(m_instance == null){
			m_instance = new LocalSession();
		}

		return m_instance;
	}

	/**
	 * コンストラクタ
	 */
	private LocalSession() {
		// 初回起動のデータはリフレッシュ必要がないため、起動時の時刻を入れる
		clientLastUpdate = new Date(System.currentTimeMillis());

	}

	// クライアント側で保持するローカル情報の削除処理
	public static void clearSessionData() {
		// ファシリティツリーのローカルキャッシュをクリア
		//m_log.debug("LocalSession.clearSessionData() start");
		FacilityTree.clearCache();
		//m_log.debug("LocalSession.clearSessionData() stop");
	}

	/**
	 * 
	 * @return
	 */
	private static Date getClientLastUpdate() {
		return clientLastUpdate;
	}

	/**
	 * 
	 * @param repositoryLastUpdate
	 */
	private static void setClientLastUpdate(Date lastUpdate) {
		clientLastUpdate = lastUpdate;
	}

	/**
	 * チェックタスクを開始する
	 * 
	 * @param inverval 間隔(分)
	 */
	public void startChecktask(int interval) {
		//m_log.debug("LocalSession.startChecktask() start : interval = " + interval);

		// タイマーが存在しない場合のみ実行
		if (m_timer == null && interval > 0) {
			//m_log.debug("LocalSession.startChecktask() setup task");

			// タイマー作成
			m_timer = new Timer(true);

			// スケジュール設定
			m_timer.schedule(new SessionCheckTask(),
					interval * 60 * 1000,
					interval * 60 * 1000);
		}
	}

	/**
	 * チェックタスクをリスタートする
	 * 
	 * @param inverval 間隔(分)
	 */
	public void restartChecktask(int interval) {
		//m_log.debug("LocalSession.restartChecktask() start : interval = " + interval);

		stopChecktask();

		startChecktask(interval);
	}


	/**
	 * チェックタスクを停止する
	 */
	public void stopChecktask() {
		//m_log.debug("LocalSession.stopChecktask() start");

		if(m_timer != null){
			// スケジュール削除
			m_timer.cancel();

			// タイマー削除
			m_timer = null;
		}

	}

	/**
	 * 
	 */
	public static void doCheck() {
		//m_log.debug("LocalSession.doCheck() start");

		// ログインチェック
		//m_log.debug("LocalSession.doCheck() Login Check");
		if(LoginManager.isLogin()){
			//m_log.debug("LocalSession.doCheck() ログイン済み");
		}else{
			//m_log.debug("LocalSession.doCheck() ログイン済みでない");
			return;
		}


		// リポジトリの最新更新時間を取得
		Date lastUpdate = null;
		//m_log.debug("LocalSession.doCheck() Get Last Update");
		try{
			lastUpdate = new Date(RepositoryEndpointWrapper.getLastUpdate());

			//m_log.debug("LocalSession.doCheck() lastUpdate = " + lastUpdate);
			//m_log.debug("LocalSession.doCheck() clientLastUpdate = " + getClientLastUpdate());

		}catch (Exception e) {
			// マネージャ停止時
			if(e instanceof ClientTransportException || e instanceof WebServiceException){
				m_log.warn("LocalSession.doCheck() Manager is dead ! , " + e.getMessage(), e);
			}
			// 想定外の例外
			else {
				m_log.warn("LocalSession.doCheck() Manager is dead !! , " +
						e.getMessage(), e);
			}
			// ダイアログを表示する
			LoginManager.disconnectManager();
			return;
		}

		//m_log.debug("LocalSession.doCheck() Do Repository Update");
		if (lastUpdate != null && getClientLastUpdate() != null) {
			// リポジトリの最新更新時刻が異なる場合にキャッシュ更新
			//m_log.debug("LocalSession.doCheck() getClientLastUpdate().compareTo(lastUpdate) = " + getClientLastUpdate().compareTo(lastUpdate));
			if (getClientLastUpdate().compareTo(lastUpdate) != 0) {
				m_log.debug("LocalSession.doCheck() update");

				// 最終更新時刻を更新
				setClientLastUpdate(lastUpdate);

				// リポジトリツリーキャッシュを更新して画面を再描画する
				FacilityTree.refresh();
			}
		}
	}

	/**
	 * EJB接続確認タイマータスク 通信エラーとなった場合はダイアログを表示する
	 */
	private class SessionCheckTask extends TimerTask {

		@Override
		public void run() {
			// TODO Auto-generated method stub
			//m_log.debug("SessionCheckTask.run() start at Date : " + (new Date()).toString());
			doCheck();
		}
	}

	private static Object o = new Object();
	public static void setDialogFlag (boolean flag) {
		synchronized (o) {
			dialogFlag = flag;
		}
	}

	public static boolean isDialogFlag () {
		return dialogFlag;
	}
}
