#!/bin/bash

# Copyright (C) 2011 NTT DATA Corporation
#
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../conf/hinemos_agent.cfg
AGENT_LIB=${HINEMOS_AGENT_HOME}/lib
AGENT_CONF=${HINEMOS_AGENT_HOME}/conf
TIMEOUT=3
export PROG=`basename $0`
export HINEMOS_AGENT_HOME=${HINEMOS_AGENT_HOME}

# Logging
function Logging() {
    MODE=$2
    OPTS="-e"
    case ${MODE} in
        withline)
            EchoLine
            Logging "$1"
            EchoLine
            return 0
            ;;
        noreturn)
            OPTS="${OPTS} -n"
            ;;
        *)
            ;;
    esac
    echo ${OPTS} "$1" >&2
    /usr/bin/logger "${PROG} $1"
}

# change current directory
cd ${HINEMOS_AGENT_HOME}/var/log

# check process
if [ -f ${HINEMOS_AGENT_PID} ]
then
        read PID < ${HINEMOS_AGENT_PID}
        if [ `ps --no-headers --pid ${PID} e | grep "java.*com.clustercontrol.agent.Agent" | wc -l` -gt 0 ]
        then
                Logging "Hinemos Agent is running..."
                exit 1
        fi
fi

# check java version
if [ `${JAVA_HOME}/bin/java -version 2>&1 | grep '%%JAVA_CHECK_REGEX%%' | wc -l` -eq 0 ]
then
        Logging "This Java is not supported."
        ${JAVA_HOME}/bin/java -version 2>&1
        exit 1
fi
if [ `${JAVA_HOME}/bin/java -version 2>&1 | grep %%OPENJDK_CHECK_REGEX%% | wc -l` -eq 0 ]
then
        Logging "This Java is not supported."
        ${JAVA_HOME}/bin/java -version 2>&1
        exit 1
fi

## tune JVM Heap Memory
JAVA_OPTS="-Xms32m -Xmx32m"

## JVM GC logging
#DATE_POSTFIX=""
#DATE_POSTFIX=".`date +%Y-%m-%d-%H%M%S`"
#JAVA_OPTS="${JAVA_OPTS} -Xloggc:${HINEMOS_AGENT_HOME}/var/log/agent_gc.log${DATE_POSTFIX} -verbose:gc -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -XX:+PrintClassHistogram"

## for jconsole
#JAVA_OPTS="${JAVA_OPTS} -Dcom.sun.management.jmxremote -Dcom.sun.management.jmxremote.port=7102 -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false"

## for OutOfMemory
JAVA_OPTS="${JAVA_OPTS} -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=${HINEMOS_AGENT_HOME}/var/log"
export _JAVA_OPTIONS="-XX:OnOutOfMemoryError='$JAVA_HOME/bin/jmap -histo %p >> ${HINEMOS_AGENT_HOME}/var/log/agent_outofmemory_histgram.log'"

## for hostname
HOSTNAME=`hostname`
JAVA_OPTS="${JAVA_OPTS} -Dhostname=${HOSTNAME}"

## classpath (java)
CP="${AGENT_LIB}/AgentWS.jar"
CP="${CP}:${AGENT_LIB}/HinemosAgent.jar"
CP="${CP}:${AGENT_LIB}/HinemosCommon.jar"
CP="${CP}:${AGENT_LIB}/commons-logging-1.1.1.jar"
CP="${CP}:${AGENT_LIB}/log4j-1.2.15.jar"
CP="${CP}:${AGENT_CONF}"

## startup
CMD="nohup ${JAVA_HOME}/bin/java ${JAVA_OPTS} -cp ${CP} com.clustercontrol.agent.Agent ${AGENT_CONF}/Agent.properties ${AGENT_CONF}/log4j.properties"
echo $CMD > ${HINEMOS_AGENT_HOME}/var/log/agent_stdouterr.log
$CMD >> ${HINEMOS_AGENT_HOME}/var/log/agent_stdouterr.log 2>&1 &
echo $! > ${HINEMOS_AGENT_PID}

## check process
read PID < ${HINEMOS_AGENT_PID}
for TIME in `seq 1 ${TIMEOUT}`
do
        sleep 1
        if [ `ps --no-headers --pid ${PID} e | grep "java.*com.clustercontrol.agent.Agent" | wc -l` -gt 0 ]
        then
                Logging "Hinemos Agent started."
                exit 0
        fi
done

Logging "Hinemos Agent startup failed."
exit 1