/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;


/**
 * Quartz関連の定義を定数として定義するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class QuartzConstant {

	/**
	 *  ジョブのグループ。<BR>
	 *  ジョブ管理のスケジュール実行を呼び出すQuartzのジョブのグループ名です。
	 */
	public static final String GROUP_NAME = "JOB";

	/**
	 *  Quartzから呼び出すJNDI名。<BR>
	 *  ジョブ管理のスケジュール実行を行う Session Bean のJNDI名です。
	 */
	public static final String JNDI_NAME = "JobController";

	/**
	 *  Quartzから呼び出すメソッド名。<BR>
	 *  ジョブ管理のスケジュール実行を行う Session Bean のメソッド名です。
	 */
	public static final String METHOD_NAME = "scheduleRunJob";

	/**
	 * 有効/無効<BR>
	 * QuartzのJobDetailに格納する属性のキー
	 */
	public static final String VALID_KEY = "valid";

	/**
	 * ジョブ名<BR>
	 * QuartzのJobDetailに格納する属性のキー
	 */
	public static final String JOB_NAME_KEY = "jobName";

	/**
	 * 作成日時<BR>
	 * QuartzのJobDetailに格納する属性のキー
	 */
	public static final String CREATE_DATE_KEY = "createDate";

	/**
	 * 最終更新日時<BR>
	 * QuartzのJobDetailに格納する属性のキー
	 */
	public static final String UPDATE_DATE_KEY = "updateDate";

	/**
	 * 新規作成ユーザ<BR>
	 * QuartzのJobDetailに格納する属性のキー
	 */
	public static final String CREATE_USER_KEY = "createUser";

	/**
	 * 最終更新ユーザ<BR>
	 * QuartzのJobDetailに格納する属性のキー
	 */
	public static final String UPDATE_USER_KEY = "updateUser";

	/**
	 * スケジュール<BR>
	 * QuartzのJobDetailに格納する属性のキー
	 */
	public static final String SCHEDULE_KEY = "schedule";



	/** Quartzからコールバックされるメソッドの引数として、ジョブユニットIDを指定する位置 */
	public static final int INDEX_JOBUNIT_ID = 0;

	/** Quartzからコールバックされるメソッドの引数として、ジョブIDを指定する位置 */
	public static final int INDEX_JOB_ID = 1;

	/** Quartzからコールバックされるメソッドの引数として、カレンダIDを指定する位置 */
	public static final int INDEX_CALENDAR_ID = 2;

	/** Quartzからコールバックされるメソッドの引数として、実行契機情報を指定する位置 */
	public static final int INDEX_TRIGGER_INFO = 3;

	/** Quartzからコールバックされるメソッドの引数の数
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#scheduleRunJob(String, String, String, JobTriggerInfo)
	 */
	public static final int ARGS_NUM = 4;


}
