package com.clustercontrol.cloud.azure.factory;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.VirtualMachineOperations;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineStartRolesParameters;

public class AzureStartInstance extends AzureAsyncOperations{
	private Logger logger = Logger.getLogger(this.getClass());
	private Configuration config = null;
	private String cloudServiceName = null;
	private String deploymentName = null;
	
	public AzureStartInstance(Configuration config,
							  String cloudServiceName,
							  String deploymentName){
		this.config = config;
		this.cloudServiceName = cloudServiceName;
		this.deploymentName = deploymentName;
	}
	
	public void execute() throws CloudManagerFault {
		OperationResponse operationResponse = new OperationResponse();
		ComputeManagementClient computeManagementClient = ComputeManagementService.create(config);
		VirtualMachineOperations virtualMachineOperations = computeManagementClient.getVirtualMachinesOperations();
		
		try {
			VirtualMachineStartRolesParameters startPrm = new VirtualMachineStartRolesParameters();
			startPrm.setRoles(this.getParams());
			
			
			logger.info("VirtualMachineOperations.beginStartingRoles(" + cloudServiceName +","+ deploymentName +")");
			operationResponse = virtualMachineOperations.beginStartingRoles(cloudServiceName, deploymentName, startPrm);
	        logger.info("RequestId:" + operationResponse.getRequestId());
	        
	        for(;;){
        		OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
     			if (!operationStatusResponse.getStatus().equals(OperationStatus.InProgress)) {
     				logger.info("Starting " + getClass().getSimpleName() + "...");
     				if(operationStatusResponse.getStatus().equals(OperationStatus.Succeeded)){
     					logger.info("successful in Starting " + getClass().getSimpleName() + "...");
     				}else{
     					logger.error("failed in Starting " + operationStatusResponse.getError());
	 					putLog("StartInstance","StartInstance was failed",operationStatusResponse.getError().getMessage());
	 					throw new CloudManagerFault(operationStatusResponse.getError().getMessage(),new Exception(operationStatusResponse.getError().getCode()));
     				}
     				return;
     			}
        	}
			
		} catch (Exception e) {
			putLog("StartInstance","StartInstance was failed",e.getMessage());
			throw new CloudManagerFault(e.getMessage(), e);
		} finally {
			logger.info("Finish AzureStartInstance:" + this.getParams());
		}
	}
}
