/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.factory;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ICloudOption;
import com.clustercontrol.cloud.IResourceManagement.ICredential;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.azure.util.AzureConstants;
import com.clustercontrol.cloud.persistence.Transactional;

@Transactional(Transactional.TransactionType.Supported)
public class AzureOption implements ICloudOption, AzureConstants {
	public static final String targetsFilePath = "var/cloud/options/azure/billing_target.dat"; 

	private ICredential credential;
	
	@Override
	public void setCredential(ICredential credential) {
		this.credential = credential;
	}

	@Override
	public ICredential getCledential() {
		return credential;
	}

	@Override
	public Billing getBillingForCloudService(String target) throws CloudManagerFault {
		/*try {
			AmazonCloudWatch cloudWatch = AzureUtil.createCloudWatch(new CloudCredential(credential.getAccessKey(), credential.getSecretKey()), null);
			
			// AWS から、課金情報を取得。
			GetMetricStatisticsRequest getMetricStatisticsRequest = new GetMetricStatisticsRequest();
			getMetricStatisticsRequest.withNamespace("AWS/Billing");
			getMetricStatisticsRequest.withMetricName("EstimatedCharges");

			// 最新の情報が取得できれば良いので、過去一日に設定。
			GregorianCalendar start = new GregorianCalendar();
			start.set(Calendar.DAY_OF_YEAR, start.get(Calendar.DAY_OF_YEAR) - 1);
			getMetricStatisticsRequest.withStartTime(start.getTime());
			getMetricStatisticsRequest.withEndTime(new GregorianCalendar().getTime());

			// 課金情報は、4 時間毎に更新されるようなので、情報の幅を1 時間。
			getMetricStatisticsRequest.withPeriod(60 * 60);

			// 最大値を取得すれば良いので、"Maximum" を対象にする。ここで指定できる情報は、他に、"Maximum", "Minimum", "SampleCount", "Sum" になる。
			getMetricStatisticsRequest.withStatistics("Maximum");
			
			// ターゲットを設定。
			if ("Total".equals(target) || target == null) {
				getMetricStatisticsRequest.withDimensions(new Dimension().withName("Currency").withValue("USD"));
			}
			else {
				getMetricStatisticsRequest.withDimensions(new Dimension().withName("ServiceName").withValue(target), new Dimension().withName("Currency").withValue("USD"));
			}

			// 情報を取得。
			GetMetricStatisticsResult resutlt = cloudWatch.getMetricStatistics(getMetricStatisticsRequest);
			Datapoint maxPoint = null;
			for (Datapoint dataPoint: resutlt.getDatapoints()) {
				if (maxPoint == null) {
					maxPoint = dataPoint;
				}
				else {
					if (maxPoint.getTimestamp().before(dataPoint.getTimestamp())) {
						maxPoint = dataPoint;
					}
				}
			}
			
			if (maxPoint != null) {
				Billing billing = new Billing(); 
				billing.setCurrency("USD");
				billing.setPrice(maxPoint.getMaximum().doubleValue());
				billing.setUpdateDate(maxPoint.getTimestamp());
				
				return billing;
			}
			else {
				return null;
			}
		}
		catch (AmazonServiceException e) {
			throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), e);
		}
		catch (Exception e) {
			throw new CloudManagerFault(e.getMessage(), e);
		}*/
		return null;
	}

	@Override
	public List<String> getCloudServicesForBilling() throws CloudManagerFault {
		try {
			List<String> targets = new ArrayList<>();
			String hinemosHome = System.getProperty("hinemos.manager.home.dir");
			try (BufferedReader reader = new BufferedReader(new FileReader(hinemosHome + "/" + targetsFilePath))) {
				String target = reader.readLine();
				while(target != null){
					targets.add(target);
					
					target = reader.readLine();
				}
			}
			targets.add(0, "Total");
			return targets;
		}
		catch (Exception e) {
			throw new InternalManagerError(e.getMessage(), e);
		}
	}
}