package com.clustercontrol.cloud.azure.factory;

import org.apache.log4j.Logger;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineOperations;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse.HostedService;

public class AzureDeleteInstance extends AzureAsyncOperations {
	private Logger logger = Logger.getLogger(this.getClass());
	private String instanceId = null;
	private Configuration config = null;
	
	public AzureDeleteInstance(Configuration config, String instanceId) {
		this.config = config;
		this.instanceId = instanceId;
	}
	
	public void execute() throws CloudManagerFault {
		
		OperationResponse operationResponse = new OperationResponse();
		
		try {
	    	logger.info("AzureDeleteInstance start: " + instanceId );

			ComputeManagementClient computeManagementClient = ComputeManagementService.create(config);

			VirtualMachineOperations virtualMachineOperations = computeManagementClient.getVirtualMachinesOperations();
			DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
			
			HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
			HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
			for (HostedService hostService: hostedServiceListResponse.getHostedServices()) {
				for (DeploymentSlot slot:AzureUtil.getDeploymentSlots()) {
					DeploymentGetResponse deploymentGetResponse = null;
					try {
			 			deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(),slot);
		 			}
		 			catch (ServiceException e) {
		 				if (e.getErrorCode().equals("ResourceNotFound"))
		 					continue;
		 				logger.error("AzureDeleteInstance: "+ instanceId + " (" + e.getErrorCode() +") "+ e.getMessage());
		 				throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), e);
		 			}

					for(Role role:deploymentGetResponse.getRoles()){
						if(role.getRoleName().equals(instanceId)){
							logger.info("VirtualMachineOperations.beginDeleting(" + hostService.getServiceName() +","+ deploymentGetResponse.getName() +","+ instanceId+")");
					 		operationResponse = virtualMachineOperations.beginDeleting(hostService.getServiceName(), deploymentGetResponse.getName(), instanceId, true);
					        logger.info("RequestId:" + operationResponse.getRequestId());
					        
					        for(;;){
				        		OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
				     			if (!operationStatusResponse.getStatus().equals(OperationStatus.InProgress)) {
				     				logger.info("beginDeleting " + getClass().getSimpleName() + "...");
				     				if(operationStatusResponse.getStatus().equals(OperationStatus.Succeeded)){
				     					logger.info("successful in beginDeleting " + getClass().getSimpleName() + "...");
				     				}else{
				     					logger.error("failed in beginDeleting " + operationStatusResponse.getError());
					 					putLog("DeleteInstance","DeleteInstance was failed",operationStatusResponse.getError().getMessage());
					 					throw new CloudManagerFault(operationStatusResponse.getError().getMessage(),new Exception(operationStatusResponse.getError().getCode()));
				     				}
				     				break;
				     			}
				        	}
					 		return;
						}
					}
				}
			}

			throw new CloudManagerFault("ResourceNotFound");
        	
		}catch(ServiceException e){
			logger.error("AzureDeleteInstance: " + instanceId + "(" + e.getErrorCode() +") "+ e.getMessage());
			putLog("DeleteInstance","DeleteInstance was failed",e.getStackTrace().toString());
			throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), e);
		}catch(Exception e){
			logger.error("AzureDeleteInstance: " + instanceId + " " + e.getMessage());
			putLog("DeleteInstance","DeleteInstance was failed",e.getStackTrace().toString());
			throw new CloudManagerFault(e.getMessage(), e);
	    } finally {
	    	logger.info("AzureDeleteInstance end: " + instanceId );
	    }		
	}
}
