package com.clustercontrol.cloud.azure.bean;

import java.util.List;

import com.clustercontrol.cloud.bean.CreateInstanceRequest;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.ws.azure.EndPoint;
import com.clustercontrol.ws.azure.HostCacheInfo;
import com.microsoft.windowsazure.management.compute.models.VirtualHardDiskHostCaching;

public class AzureCreateInstanceRequest extends CreateInstanceRequest{
	public AzureCreateInstanceRequest() {
		super();
	}
	
	public AzureCreateInstanceRequest(String instanceName,
									String cloudServiceName,
									String storageAccountName,
									String containerName,
									String hostCacheConfig,
									List<EndPoint> endPoints,
									String passWord,
									String accountName,
									String osType,
									String deploymentName,
									String sizeName,
									String facilityId,
									String facilityName,
									String description,
									String nodeName,
									String imageName,
									Boolean availabilitySet,
									String availabilitySetName,
									String size,
									AzureImage image,
									Tag tag,
									Boolean isRestore) {
		this.instanceName = instanceName;
		this.cloudServiceName = cloudServiceName;
		this.deploymentName = deploymentName;
		this.storageAccountName = storageAccountName;
		this.containerName = containerName;
		this.hostCacheConfig = hostCacheConfig;
		this.endPoints = endPoints;
		this.passWord = passWord;
		this.accountName = accountName;
		this.osType = osType;
		this.sizeName = sizeName;
		this.imageName = imageName;
		this.availabilitySet = availabilitySet;
		this.availabilitySetName = availabilitySetName;
		this.size = size;
		this.image = image;
		this.tag = tag;
		this.isRestore = isRestore;

	}
	private String instanceName;
	private String cloudServiceName;
	private String deploymentName;
	private String storageAccountName;
	private String containerName;
	private String hostCacheConfig;
	private List<EndPoint> endPoints;
	private String passWord;
	private String accountName;
	private String osType;

	private String sizeName;
	private String imageName;
	private Boolean availabilitySet;
	private String availabilitySetName;
	
	private String size;
	private AzureImage image;
	
	private Tag tag;
	
	private Boolean isRestore=false;

	/**
	 * インスタンス名を取得します。
	 *
	 * @return インスタンス名。
	 */
	@ElementId("instanceName")
	public String getInstanceName() {
		return instanceName;
	}
	/**
	 * インスタンス名を指定します。
	 * 
	 * @param instanceName　インスタンス名。
	 */
	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}
	
	/**
	 * クラウドサービス名を取得します。
	 * 
	 * @return クラウドサービス名。
	 */
	@ElementId("cloudServiceName")
	public String getCloudServiceName() {
		return cloudServiceName;
	}
	/**
	 * クラウドサービス名を指定します。
	 * 
	 * @param cloudServiceName　クラウドサービス名。
	 */
	public void setCloudServiceName(String cloudServiceName) {
		this.cloudServiceName = cloudServiceName;
	}
	
	/**
	 * デプロイメント名を取得します。
	 * 
	 * @return デプロイメント名。
	 */
	@ElementId("deploymentName")
	public String getDeploymentName() {
		return deploymentName;
	}
	/**
	 * デプロイメント名を指定します。
	 * 
	 * @param deploymentName　デプロイメント名。
	 */
	public void setDeploymentName(String deploymentName) {
		this.deploymentName = deploymentName;
	}
	
	/**
	 * ストレージアカウント名を取得します。
	 * 
	 * @return ストレージアカウント名。
	 */
	@ElementId("storageAccountName")
	public String getStorageAccountName() {
		return storageAccountName;
	}
	/**
	 * ストレージアカウント名を指定します。
	 * 
	 * @param storageAccountName　ストレージアカウント名。
	 */
	public void setStorageAccountName(String storageAccountName) {
		this.storageAccountName = storageAccountName;
	}
	
	/**
	 * コンテナー名を取得します。
	 * 
	 * @return コンテナー名。
	 */
	@ElementId("containerName")
	public String getContainerName() {
		return this.containerName;
	}
	/**
	 * コンテナー名を指定します。
	 * 
	 * @param containerName　コンテナー名。
	 */
	public void setContainerName(String containerName) {
		this.containerName = containerName;
	}
	
	/**
	 * ホストキャッシュ設定を取得します。
	 * 
	 * @return ホストキャッシュ設定
	 */
	@ElementId("hostCacheConfig")
	public VirtualHardDiskHostCaching getHostCacheConfig() {
		if(this.hostCacheConfig.equals(HostCacheInfo.hostCahe_READ_WRITE)){
			return VirtualHardDiskHostCaching.ReadWrite;
		}else if(this.hostCacheConfig.equals(HostCacheInfo.hostCahe_READ_ONLY)){
			return VirtualHardDiskHostCaching.ReadOnly;
		}else{
			return VirtualHardDiskHostCaching.None;
		}
	}
	/**
	 * ホストキャッシュ設定を指定します。
	 * 
	 * @param hostCacheConfig　ホストキャッシュ設定。
	 */
	public void setHostCacheConfig(String hostCacheConfig) {
		this.hostCacheConfig = hostCacheConfig;
	}
	
	/**
	 * エンドポイントを取得します。
	 * 
	 * @return エンドポイント
	 */
	@ElementId("endPoints")
	public List<EndPoint> getEndPoint(){
		return this.endPoints;
	}
	/**
	 * エンドポイントを指定します。
	 * 
	 * @param endPoints　エンドポイント。
	 */
	public void setEndPoint(List<EndPoint> endPoints){
		this.endPoints = endPoints;
	}
	
	/**
	 * パスワードを取得します。
	 * 
	 * @return パスワード
	 */
	@ElementId("passWord")
	public void setPassWord(String passWord){
		this.passWord = passWord;
	}
	/**
	 * パスワードを指定します。
	 * 
	 * @param passWord　パスワード。
	 */
	public String getPassWord(){
		return this.passWord;
	}
	
	/**
	 * アカウント名を取得します。
	 * 
	 * @return アカウント名
	 */
	@ElementId("accountName")
	public void setAccountName(String accountName){
		this.accountName = accountName;
	}
	/**
	 * アカウント名を指定します。
	 * 
	 * @param accountName　アカウント名。
	 */
	public String getAccountName(){
		return this.accountName;
	}
	
	/**
	 * OS名を取得します。
	 * 
	 * @return OS名
	 */
	@ElementId("osType")
	public void setOSType(String osType){
		this.osType = osType;
	}
	/**
	 * OS名を指定します。
	 * 
	 * @param osType　OS名。
	 */
	public String getOSType(){
		return this.osType;
	}

	/**
	 * @return sizeName
	 */
	public String getSizeName() {
		return sizeName;
	}

	/**
	 * @param sizeName セットする sizeName
	 */
	public void setSizeName(String sizeName) {
		this.sizeName = sizeName;
	}

	/**
	 * @return txtIMAGE
	 */
	public String getTxtIMAGE() {
		return imageName;
	}

	/**
	 * @param txtIMAGE セットする txtIMAGE
	 */
	public void setTxtIMAGE(String txtIMAGE) {
		this.imageName = txtIMAGE;
	}

	/**
	 * @return btnAvailabilitySet
	 */
	public Boolean getAvailabilitySet() {
		return availabilitySet;
	}

	/**
	 * @param availabilitySet セットする availabilitySet
	 */
	public void setAvailabilitySet(Boolean availabilitySet) {
		this.availabilitySet = availabilitySet;
	}

	/**
	 * @return availabilitySetName
	 */
	public String getAvailabilitySetName() {
		return availabilitySetName;
	}

	/**
	 * @param availabilitySetName セットする availabilitySetName
	 */
	public void setAvailabilitySetName(String availabilitySetName) {
		this.availabilitySetName = availabilitySetName;
	}
	
	/**
	 * インスタンスのサイズを取得します。
	 * 
	 * @return size
	 */
	public void setSize(String size){
		this.size = size;
	}
	/**
	 * インスタンスのサイズを指定します。
	 * 
	 * @param size　インスタンスのサイズ。
	 */
	public String getSize(){
		return this.size;
	}
	
	/**
	 * イメージを取得します。
	 * 
	 * @return image
	 */
	public void setImage(AzureImage image){
		this.image = image;
	}
	/**
	 * イメージを指定します。
	 * 
	 * @param image　インスタンスのイメージ。
	 */
	public AzureImage getImage(){
		return this.image;
	}
	
	/**
	 * タグを取得します。
	 * 
	 * @return tag
	 */
	public void setTag(Tag tag){
		this.tag = tag;
	}
	/**
	 * タグを指定します。
	 * 
	 * @param tag　インスタンスのタグ。
	 */
	public Tag getTag(){
		return this.tag;
	}
	
	/**
	 * リストアフラグをONにします。
	 * 
	 * @param リストアフラグ。
	 */
	@ElementId("isRestore")
	public void setRestore(boolean isRestore){
		this.isRestore=isRestore;
	}
	
	/**
	 * リストアフラグを取得します。
	 * 
	 * @return isRestore
	 */
	
	public boolean isRestore(){
		return this.isRestore;
	}
	
}
