/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public abstract class AbstractProcessor<A extends Annotation> implements Processor<A> {
	protected A annotation;
	protected Method getMethod;
	protected Method setMethod;
	
	@Override
	public void init(A annotation, Method getMethod, Method setMethod) {
		this.annotation = annotation;
		this.getMethod = getMethod;
		this.setMethod = setMethod;
	}

	@Override
	public void postLoad(Object entity) throws Exception {
	}

	@Override
	public void prePersist(Object entity) throws Exception {
	}

	@Override
	public void postPersist(Object entity) throws Exception {
	}

	@Override
	public void preUpdate(Object entity) throws Exception {
	}

	@Override
	public void postUpdate(Object entity) throws Exception {
	}
}
