/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.ObjectPrivilegeMode;
import com.clustercontrol.accesscontrol.model.ObjectPrivilegeEntity;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.Messages;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.commons.CloudConstants;
import com.clustercontrol.cloud.persistence.BooleanTFConverter;
import com.clustercontrol.cloud.util.ObjectPrivilegeUtil;
import com.clustercontrol.commons.util.ObjectSharingService;
import com.clustercontrol.notify.util.INotifyOwnerDeterminer;

/**
 * 本当は、エンタープライズ側にあるべきクラス<BR>
 * eclipselink の weaving の問題で、CloudManagerBase へ移動。DB のスキーマも CloudManagerBase に含まれる。
 * 
 */
@Entity
@Table(name = "cc_cloud_billing_alarm")
public class BillingAlarmDao extends HinemosObjectDao {
	public static class AA implements INotifyOwnerDeterminer {
		@Override
		public String getEventOwnerRoleId(String monitorId, String monitorDetailId, String pluginId, String facilityId) {
			BillingAlarmDao dao = SessionService.current().getEntityManagerEx().find(BillingAlarmDao.class, monitorId);
			return dao != null ? dao.getOwnerRoleId(): null;
		}

		@Override
		public String getStatusOwnerRoleId(String monitorId, String monitorDetailId, String pluginId, String facilityId) {
			BillingAlarmDao dao = SessionService.current().getEntityManagerEx().find(BillingAlarmDao.class, monitorId);
			return dao != null ? dao.getOwnerRoleId(): null;
		}
	}

	static {
		ObjectSharingService.objectRegistry().put(INotifyOwnerDeterminer.class, CloudConstants.pluginId_billing_alarm, AA.class);
	}
	
	public static enum MonitorKind {
		delta,
		sum
	}
	
	private String pluginId;
	private String alarmId;
	private String alarmName;
	private String description;
	private String facilityId;
	private String ownerRoleId;
	private MonitorKind monitorKind;
	private Double thresholdInfoLimit;
	private Double thresholdWarnLimit;
	private String unit;
	private String notifyGroupId;
	private Boolean validFlg;
	private String application;
	private Timestamp lastNotifiedDay;
	private List<ObjectPrivilegeEntity> objectPrivileges;

	public BillingAlarmDao(String pluginId, String alarmId, String alarmName, String facilityId,
			String description, String ownerRoleId, MonitorKind monitorKind,
			Double thresholdInfoLimit, Double thresholdWarnLimit, String unit,
			String notifyGroupId, Boolean validFlg, String application, Timestamp regDate, Timestamp updateDate,
			String regUser, String updateUser, Timestamp lastNotifiedDay) {
		super(regDate, updateDate, regUser, updateUser);
		this.pluginId = pluginId;
		this.alarmId = alarmId;
		this.alarmName = alarmName;
		this.facilityId = facilityId;
		this.description = description;
		this.ownerRoleId = ownerRoleId;
		this.monitorKind = monitorKind;
		this.thresholdInfoLimit = thresholdInfoLimit;
		this.thresholdWarnLimit = thresholdWarnLimit;
		this.unit = unit;
		this.notifyGroupId = notifyGroupId;
		this.validFlg = validFlg;
		this.application = application;
		this.lastNotifiedDay = lastNotifiedDay;
	}

	public BillingAlarmDao(BillingAlarmDao otherData) {
		super(otherData);
		setAlarmId(otherData.getAlarmId());
		setAlarmName(otherData.getAlarmName());
		setFacilityId(otherData.getFacilityId());
		setDescription(otherData.getDescription());
		setOwnerRoleId(otherData.getOwnerRoleId());
		setMonitorKind(otherData.getMonitorKind());
		setThresholdInfoLimit(otherData.getThresholdInfoLimit());
		setThresholdWarnLimit(otherData.getThresholdWarnLimit());
		setUnit(otherData.getUnit());
		setNotifyGroupId(otherData.getNotifyGroupId());
		setValidFlg(otherData.getValidFlg());
		setApplication(otherData.getApplication());
		setLastNotifiedDay(otherData.getLastNotifiedDay());
	}

	public BillingAlarmDao() {
	}

	@Column(name="plugin_id")
	public String getPluginId() {
		return pluginId;
	}
	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}
	
	@Column(name="alarm_id")
	@Id
	public String getAlarmId()
	{
		return this.alarmId;
	}
	public void setAlarmId(String alarmId)
	{
		this.alarmId = alarmId;
	}

	@Column(name="alarm_name")
	public String getAlarmName()
	{
		return this.alarmName;
	}
	public void setAlarmName(String alarmName)
	{
		this.alarmName = alarmName;
	}

	@Column(name="description")
	public String getDescription()
	{
		return this.description;
	}
	public void setDescription(String description)
	{
		this.description = description;
	}

	@Column(name="facility_id")
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}

	@Convert(converter=BooleanTFConverter.class)
	@Column(name="valid_flg")
	public Boolean getValidFlg()
	{
		return this.validFlg;
	}
	public void setValidFlg(Boolean validFlg)
	{
		this.validFlg = validFlg;
	}

	@Column(name="owner_role_id")
	public String getOwnerRoleId() {
		return ownerRoleId;
	}

	public void setOwnerRoleId(String ownerRoleId) {
		this.ownerRoleId = ownerRoleId;
	}

	@Column(name="monitor_kind")
	@Enumerated(EnumType.STRING)
	public MonitorKind getMonitorKind() {
		return monitorKind;
	}

	public void setMonitorKind(MonitorKind monitorKind) {
		this.monitorKind = monitorKind;
	}

	@Column(name="threshold_info_limit")
	public Double getThresholdInfoLimit() {
		return thresholdInfoLimit;
	}

	public void setThresholdInfoLimit(Double thresholdInfoLimit) {
		this.thresholdInfoLimit = thresholdInfoLimit;
	}

	@Column(name="threshold_warn_limit")
	public Double getThresholdWarnLimit() {
		return thresholdWarnLimit;
	}

	public void setThresholdWarnLimit(Double thresholdWarnLimit) {
		this.thresholdWarnLimit = thresholdWarnLimit;
	}

	@Column(name="unit")
	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	@Column(name="notify_group_id")
	public String getNotifyGroupId() {
		return notifyGroupId;
	}

	public void setNotifyGroupId(String notifyGroupId) {
		this.notifyGroupId = notifyGroupId;
	}

	@Column(name="application")
	public String getApplication() {
		return application;
	}

	public void setApplication(String application) {
		this.application = application;
	}

	@Column(name="last_notified_day")
	public Timestamp getLastNotifiedDay() {
		return lastNotifiedDay;
	}

	public void setLastNotifiedDay(Timestamp lastNotifiedDay) {
		this.lastNotifiedDay = lastNotifiedDay;
	}

	@Override
	public Object getId() {
		return getAlarmId();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((alarmId == null) ? 0 : alarmId.hashCode());
		result = prime * result
				+ ((alarmName == null) ? 0 : alarmName.hashCode());
		result = prime * result
				+ ((application == null) ? 0 : application.hashCode());
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime * result
				+ ((facilityId == null) ? 0 : facilityId.hashCode());
		result = prime * result
				+ ((lastNotifiedDay == null) ? 0 : lastNotifiedDay.hashCode());
		result = prime * result
				+ ((monitorKind == null) ? 0 : monitorKind.hashCode());
		result = prime * result
				+ ((notifyGroupId == null) ? 0 : notifyGroupId.hashCode());
		result = prime * result
				+ ((ownerRoleId == null) ? 0 : ownerRoleId.hashCode());
		result = prime * result
				+ ((pluginId == null) ? 0 : pluginId.hashCode());
		result = prime
				* result
				+ ((thresholdInfoLimit == null) ? 0 : thresholdInfoLimit
						.hashCode());
		result = prime
				* result
				+ ((thresholdWarnLimit == null) ? 0 : thresholdWarnLimit
						.hashCode());
		result = prime * result + ((unit == null) ? 0 : unit.hashCode());
		result = prime * result
				+ ((validFlg == null) ? 0 : validFlg.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		BillingAlarmDao other = (BillingAlarmDao) obj;
		if (alarmId == null) {
			if (other.alarmId != null)
				return false;
		} else if (!alarmId.equals(other.alarmId))
			return false;
		if (alarmName == null) {
			if (other.alarmName != null)
				return false;
		} else if (!alarmName.equals(other.alarmName))
			return false;
		if (application == null) {
			if (other.application != null)
				return false;
		} else if (!application.equals(other.application))
			return false;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (facilityId == null) {
			if (other.facilityId != null)
				return false;
		} else if (!facilityId.equals(other.facilityId))
			return false;
		if (lastNotifiedDay == null) {
			if (other.lastNotifiedDay != null)
				return false;
		} else if (!lastNotifiedDay.equals(other.lastNotifiedDay))
			return false;
		if (monitorKind != other.monitorKind)
			return false;
		if (notifyGroupId == null) {
			if (other.notifyGroupId != null)
				return false;
		} else if (!notifyGroupId.equals(other.notifyGroupId))
			return false;
		if (ownerRoleId == null) {
			if (other.ownerRoleId != null)
				return false;
		} else if (!ownerRoleId.equals(other.ownerRoleId))
			return false;
		if (pluginId == null) {
			if (other.pluginId != null)
				return false;
		} else if (!pluginId.equals(other.pluginId))
			return false;
		if (thresholdInfoLimit == null) {
			if (other.thresholdInfoLimit != null)
				return false;
		} else if (!thresholdInfoLimit.equals(other.thresholdInfoLimit))
			return false;
		if (thresholdWarnLimit == null) {
			if (other.thresholdWarnLimit != null)
				return false;
		} else if (!thresholdWarnLimit.equals(other.thresholdWarnLimit))
			return false;
		if (unit == null) {
			if (other.unit != null)
				return false;
		} else if (!unit.equals(other.unit))
			return false;
		if (validFlg == null) {
			if (other.validFlg != null)
				return false;
		} else if (!validFlg.equals(other.validFlg))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "BillingAlarmDao [pluginId=" + pluginId + ", alarmId=" + alarmId
				+ ", alarmName=" + alarmName + ", description=" + description
				+ ", facilityId=" + facilityId + ", ownerRoleId=" + ownerRoleId
				+ ", monitorKind=" + monitorKind + ", thresholdInfoLimit="
				+ thresholdInfoLimit + ", thresholdWarnLimit="
				+ thresholdWarnLimit + ", unit=" + unit + ", notifyGroupId="
				+ notifyGroupId + ", validFlg=" + validFlg + ", application="
				+ application + ", lastNotifiedDay=" + lastNotifiedDay + "]";
	}
	
	@OneToMany
	@JoinColumns (
		{
			@JoinColumn(name="object_id", referencedColumnName="alarm_id"),
			@JoinColumn(name="object_type", referencedColumnName="plugin_id")
		}
	)
	public List<ObjectPrivilegeEntity> getObjectPrivileges() {
		return objectPrivileges;
	}
	public void setObjectPrivileges(List<ObjectPrivilegeEntity> objectPrivileges) {
		this.objectPrivileges = objectPrivileges;
	}

	public static BillingAlarmDao getBillingAlarmDao(String alarmId, String userId, ObjectPrivilegeMode mode) throws CloudManagerFault {
		return ObjectPrivilegeUtil.getObject(BillingAlarmDao.class, "alarmId", alarmId, userId, mode, Messages.messages());
	}

	public static List<BillingAlarmDao> getBillingAlarmDaos(String userId, ObjectPrivilegeMode mode) throws CloudManagerFault {
		return ObjectPrivilegeUtil.getObjects(BillingAlarmDao.class, "alarmId", userId, mode);
	}
}