/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.util.List;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.IdentityNullAllow;
import com.clustercontrol.cloud.validation.annotation.NotNull;

/**
 * クラウドインスタンスの停止に必要な情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#stopInstance(String,String,StopInstanceRequest) stopInstance 関数} にて使用される。
 *
 */
public class StopInstanceRequest {
	private String instanceId;
	private Boolean runJobFlg = false;
	private String jobId;
	private List<TemplateJobsArgument> arguments;

	/**
	 * 停止するクラウドインスタンスのインスタンス Id を取得する。
	 * 
	 * @return インスタンス Id
	 */
	@NotNull
	public String getInstanceId() {
		return instanceId;
	}

	/**
	 * 停止するクラウドインスタンスのインスタンス Id を指定する。
	 * この値は、{@link com.clustercontrol.ws.cloud.CloudEndpoint#stopInstance(String,String,StopInstanceRequest) stopInstance 関数} を実行する際、必須となります。
	 * 
	 * @param instanceId インスタンス Id
	 */
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	/**
	 * クラウドインスタンス停止時のテンプレートジョブの実行制御フラグを取得する。
	 * 
	 * @return true の場合、実行。false の場合、実行しない。null の false と同様。
	 */
	public Boolean getRunJobFlg() {
		return runJobFlg;
	}

	/**
	 * クラウドインスタンス停止時のテンプレートジョブの実行を制御する。
	 * 
	 * @param runJobFlg　true の場合、実行。false の場合、実行しない。null の false と同様。
	 */
	public void setRunJobFlg(Boolean runJobFlg) {
		this.runJobFlg = runJobFlg;
	}

	/**
	 * クラウドインスタンス停止時の実行するテンプレートジョブを取得します。
	 * null の場合、テンプレートが指定されているクラウドインスタンスにて、既定のテンプレートジョブが実行されます。
	 * 
	 * @return テンプレートジョブ Id。
	 */
	@ElementId("jobId")
	@IdentityNullAllow
	public String getJobId() {
		return jobId;
	}

	/**
	 * クラウドインスタンス停止時の実行するテンプレートジョブを指定します。
	 * null の場合、テンプレートが指定されているクラウドインスタンスにて、既定のテンプレートジョブが実行されます。
	 * 
	 * @param jobId テンプレートジョブ Id。
	 */
	public void setJobId(String jobId) {
		this.jobId = jobId;
	}

	/**
	 * テンプレートジョブに渡す引数リストを指定する。
	 * 
	 * @param arguments ジョブの引数リスト
	 */
	@NotNull
	@ElementId("templateArguments")
//	@ListElement
	public List<TemplateJobsArgument> getArguments() {
		return arguments;
	}
	/**
	 * テンプレートジョブに渡す引数リストを取得する。
	 * 
	 * @return ジョブの引数リスト
	 */
	public void setArguments(List<TemplateJobsArgument> arguments) {
		this.arguments = arguments;
	}
}
