/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;


// インスタンスの状態
public enum InstanceStateKind {
	pending("pending"),
	running("running"),
	shutting_down("shutting-down"),
	terminated("terminated"),
	stopping("stopping"),
	stopped("stopped"),
	rebooting("rebooting");
	
	private final String label;
	
	private InstanceStateKind(String label) {
		this.label = label;
	}

	public String label() {
		return label;
	}
	
	public static InstanceStateKind byLabel(String label) {
		String name = label.replace('-', '_');
		return valueOf(name);
	}
}