/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;
import java.sql.Timestamp;

import javax.xml.bind.annotation.XmlTransient;

import com.clustercontrol.cloud.dao.CloudTemplateDao;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.ReadOnly;
import com.clustercontrol.cloud.validation.annotation.Size;

public class CloudTemplate implements Serializable {	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5384633651482295932L;
	
	private CloudTemplateDao data;
	private String cloudTypeId;

	public CloudTemplate() {
		super();
		this.data = new CloudTemplateDao();
	}

	public CloudTemplate(CloudTemplateDao tableData, String cloudTypeId) {
		super();
		this.data = new CloudTemplateDao(tableData);
		this.cloudTypeId = cloudTypeId;
	}
	
	@Size(elementId = "cloudTemplate.templateId", max = 64)
	@NotNull(elementId = "cloudTemplate.templateId")
	public String getTemplateId() {
		return data.getTemplateId();
	}

	public void setTemplateId(String templateId) {
		data.setTemplateId(templateId);
	}
	@Size(elementId = "cloudTemplate.templateName", max = 128)
	public String getTemplateName() {
		return data.getTemplateName();
	}

	public void setTemplateName(String templateName) {
		data.setTemplateName(templateName);
	}

	public String getCloudTypeId() {
		return cloudTypeId;
	}

	public void setCloudTypeId(String cloudTypeId) {
		this.cloudTypeId = cloudTypeId;
	}

	@Size(elementId = "cloudTemplate.cloudUserId", max = 128)
	public String getCloudUserId() {
		return data.getCloudUserId();
	}

	public void setCloudUserId(String accessKey) {
		data.setCloudUserId(accessKey);
	}

	@Size(elementId = "cloudTemplate.imageId", max = 64)
	public String getImageId() {
		return data.getImageId();
	}

	/**
	 * 起動ジョブ Id を取得する。
	 * 
	 * @return 起動ジョブ Id。
	 */
	public void setImageId(String imageId) {
		data.setImageId(imageId);
	}
	
	public String getJobUnitId() {
		return data.getJobUnitId();
	}

	/**
	 * 起動ジョブ Id を指定する。null 可。
	 * 
	 * @param launchJobId 起動ジョブ Id。
	 */
	public void setJobUnitId(String jobUnitId) {
		data.setJobUnitId(jobUnitId);
	}

	/**
	 * 起動ジョブ Id を取得する。
	 * 
	 * @return 起動ジョブ Id。
	 */
	@Size(elementId = "cloudTemplate.launchJobId", max = 64)
//	@NotNull(elementId = "cloudTemplate.launchJobId")
	public String getLaunchJobId() {
		return data.getLaunchJobId();
	}

	/**
	 * 起動ジョブ Id を指定する。null 可。
	 * 
	 * @param launchJobId 起動ジョブ Id。
	 */
	public void setLaunchJobId(String launchJobId) {
		data.setLaunchJobId(launchJobId);
	}

	/**
	 * 開始ジョブ Id を取得する。
	 * 
	 * @return 開始ジョブ Id。
	 */
	@Size(elementId = "cloudTemplate.startJobId", max = 64)
	public String getStartJobId() {
		return data.getStartJobId();
	}

	/**
	 * 開始ジョブ Id を指定する。null 可。
	 * 
	 * @param startJobId 開始ジョブ Id。
	 */
	public void setStartJobId(String startJobId) {
		data.setStartJobId(startJobId);
	}

	/**
	 * 停止ジョブ Id を取得する。
	 * 
	 * @return 停止ジョブ Id。
	 */
	@Size(elementId = "cloudTemplate.stopJobId", max = 64)
	public String getStopJobId() {
		return data.getStopJobId();
	}

	/**
	 * 停止ジョブ Id を指定する。null 可。
	 * 
	 * @param stopJobId 停止ジョブ Id。
	 */
	public void setStopJobId(String stopJobId) {
		data.setStopJobId(stopJobId);
	}
	
	public String getAccountResourceId() {
		return data.getAccountResourceId();
	}

	public void setAccountResourceId(String accountResourceId) {
		data.setAccountResourceId(accountResourceId);
	}
	
	/**
	 * リージョン名を取得する。
	 * 
	 * @return リージョン名
	 */
	@NotNull(elementId = "cloudTemplate.region")
	public String getRegion() {
		return data.getRegion();
	}

	/**
	 * リージョン名を指定する。
	 * 作成および編集時に必ず指定する必要があります。
	 * 
	 * @param regionName　リージョン名
	 */
	public void setRegion(String region) {
		data.setRegion(region);
	}
	/**
	 * 登録日を取得します。
	 * 
	 * @return 登録日。
	 */
	@ReadOnly
	public Long getRegDate() {
		return data.getRegDate() != null ? data.getRegDate().getTime(): null;
	}
	/**
	 * 登録日を指定します。参照時のみ有効となるので使用しません。
	 * 
	 * @param regDate 登録日。
	 */
	public void setRegDate(Long regDate) {
		if (regDate == null) {
			data.setRegDate(null);
		}
		else {
			data.setRegDate(new Timestamp(regDate));
		}
	}
	/**
	 * 更新日を取得します。
	 * 
	 * @return 更新日。
	 */
	@ReadOnly
	public Long getUpdateDate() {
		return data.getUpdateDate() != null ? data.getUpdateDate().getTime(): null;
	}
	/**
	 * 更新日を指定します。参照時のみ使用されるプロパティのため、この関数は使用しません。
	 * 
	 * @param updateDate 更新日。
	 */
	public void setUpdateDate(Long updateDate) {
		if (updateDate == null) {
			data.setUpdateDate(null);
		}
		else {
			data.setUpdateDate(new Timestamp(updateDate));
		}
	}

	/**
	 * 登録ユーザーを取得します。
	 * 
	 * @return 登録ユーザー。
	 */
	@ReadOnly
	public String getRegUser() {
		return data.getRegUser();
	}
	
	/**
	 * 登録ユーザーを指定します。参照時のみ使用されるプロパティのため、この関数は使用しません。
	 * 
	 * @param regUser 登録ユーザー。
	 */
	public void setRegUser(String regUser) {
		data.setRegUser(regUser);
	}

	/**
	 * 更新ユーザーを取得します。
	 * 
	 * @return 更新ユーザー。
	 */
	@ReadOnly
	public String getUpdateUser() {
		return data.getUpdateUser();
	}

	/**
	 * 更新ユーザーを指定します。参照時のみ使用されるプロパティのため、この関数は使用しません。
	 * 
	 * @param updateUser 更新ユーザー。
	 */
	public void setUpdateUser(String updateUser) {
		data.setUpdateUser(updateUser);
	}

	@XmlTransient
	public CloudTemplateDao getTableData() {
		return data;
	}
}