/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ws.azure;

import com.clustercontrol.accesscontrol.bean.PrivilegeConstant;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.azure.AzureOptionPropertyConstants;
import com.clustercontrol.cloud.azure.bean.AzureCreateInstanceRequest;
import com.clustercontrol.cloud.azure.bean.AzureCreateStorageRequest;
import com.clustercontrol.cloud.azure.bean.AzureImage;
import com.clustercontrol.cloud.azure.bean.AzureRestoreStorageRequest;
import com.clustercontrol.cloud.azure.bean.SnapShotInfo;
import com.clustercontrol.cloud.azure.bean.StorageSize;
import com.clustercontrol.cloud.azure.factory.AzureAsyncExecution;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperationStatus;
import com.clustercontrol.cloud.azure.factory.AzureAttachStorage;
import com.clustercontrol.cloud.azure.factory.AzureCreateInstance;
import com.clustercontrol.cloud.azure.factory.AzureDetachStorage;
import com.clustercontrol.cloud.azure.util.AzureConstants;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.clustercontrol.cloud.bean.CloudStorage;
import com.clustercontrol.cloud.bean.CreateStorageRequest;
import com.clustercontrol.cloud.factory.CloudRoleConstants;
import com.clustercontrol.cloud.factory.IStorageOperator;
import com.clustercontrol.cloud.util.ResourceUtil;
import com.clustercontrol.cloud.validation.AuthorizingValidator_role_region;
import com.clustercontrol.cloud.validation.annotation.CustomMethodValidation;
import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.Into;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.Size;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.ws.azure.AzureOptionEndpoint;
import com.clustercontrol.ws.azure.DataVirtualHardDisks;
import com.clustercontrol.ws.azure.InstanceInfo;
import com.clustercontrol.ws.cloud.IWebServiceBase;
import com.clustercontrol.ws.cloud.security.HinemosAccessRight;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.AffinityGroupOperations;
import com.microsoft.windowsazure.management.ManagementClient;
import com.microsoft.windowsazure.management.ManagementService;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.DeploymentOperations;
import com.microsoft.windowsazure.management.compute.HostedServiceOperations;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.HostedServiceListResponse;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.RoleInstance;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskCreateResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskGetResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskListResponse;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageListResponse;
import com.microsoft.windowsazure.management.models.AffinityGroupListResponse;
import com.microsoft.windowsazure.management.storage.StorageAccountOperations;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import com.microsoft.windowsazure.management.storage.StorageManagementService;
import com.microsoft.windowsazure.management.storage.models.StorageAccount;
import com.microsoft.windowsazure.management.storage.models.StorageAccountGetKeysResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountListResponse;
import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.BlobService;
import com.microsoft.windowsazure.services.blob.models.GetBlobResult;
import com.microsoft.windowsazure.services.blob.models.ListContainersResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import org.apache.log4j.Logger;

@WebService(serviceName="AzureOptionEndpointService", portName="AzureOptionEndpointPort", targetNamespace="http://azure.ws.clustercontrol.com", endpointInterface="com.clustercontrol.ws.azure.AzureOptionEndpoint")
public class AzureOptionEndpointImpl
implements AzureOptionEndpoint,
IWebServiceBase,
AzureConstants,
CloudRoleConstants {
    @Resource
    private WebServiceContext wsctx;

    private Configuration getConfiguration() throws CloudManagerFault {
        ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
        return AzureUtil.getConfiguration(context.getAccessDestionation().getCloudUser().getAccessKey(), context.getAccessDestionation().getCloudUser().getSecretKey());
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public String getRegionByCloudService(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="cloudServiceName") @Identity String cloudServiceName) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Configuration config = this.getConfiguration();
        ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
        ManagementClient managementClient = ManagementService.create((Configuration)config);
        Logger logger = Logger.getLogger(this.getClass());
        HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
        AffinityGroupOperations affinityGroupOperations = managementClient.getAffinityGroupsOperations();
        try {
            HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
            for (HostedServiceListResponse.HostedService hostedService : hostedServiceListResponse.getHostedServices()) {
                if (!hostedService.getServiceName().equals(cloudServiceName)) continue;
                if (hostedService.getProperties().getLocation() != null) {
                    return hostedService.getProperties().getLocation();
                }
                AffinityGroupListResponse affinityGroupListResponse = affinityGroupOperations.list();
                for (AffinityGroupListResponse.AffinityGroup af : affinityGroupListResponse.getAffinityGroups()) {
                    if (!af.getName().equals(hostedService.getProperties().getAffinityGroup())) continue;
                    return af.getLocation();
                }
            }
            logger.info((Object)"Successful in get Region by Cloud Service");
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        throw new InternalManagerError();
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<String> getStorageAccountByRegion(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ArrayList<String> storageAccountNames = new ArrayList<String>();
        try {
            Configuration config = this.getConfiguration();
            ManagementClient managementClient = ManagementService.create((Configuration)config);
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
            StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            AffinityGroupOperations affinityGroupOperations = managementClient.getAffinityGroupsOperations();
            AffinityGroupListResponse affinityGroupListResponse = affinityGroupOperations.list();
            StorageAccountListResponse storageServiceListResponse = storageAccountOperations.list();
            for (StorageAccount storageAccount : storageServiceListResponse.getStorageAccounts()) {
                if (!AzureUtil.compareLocation(region, storageAccount.getProperties().getLocation(), storageAccount.getProperties().getAffinityGroup(), affinityGroupListResponse.getAffinityGroups())) continue;
                storageAccountNames.add(storageAccount.getName());
            }
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return storageAccountNames;
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<String> getStorageAccountByCloudService(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="cloudServiceName") @Identity String cloudServiceName) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        List<String> StorageAccountList = this.getStorageAccountByRegion(roleId, this.getRegionByCloudService(roleId, region, cloudServiceName));
        return StorageAccountList;
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<DataVirtualHardDisks> getAttacheableDataVirtualHardDisk(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull String instanceId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ArrayList<DataVirtualHardDisks> attacheableDataVirtualHardDisks = new ArrayList<DataVirtualHardDisks>();
        try {
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            ArrayList vmds = computeManagementClient.getVirtualMachineDisksOperations().listDisks().getDisks();
            for (VirtualMachineDiskListResponse.VirtualMachineDisk vmd : vmds) {
                if (vmd.getUsageDetails() != null) continue;
                DataVirtualHardDisks dvhds = new DataVirtualHardDisks();
                dvhds.setName(vmd.getName());
                dvhds.setOSType(vmd.getOperatingSystemType());
                dvhds.setMediaLink(vmd.getMediaLinkUri());
                dvhds.setRoleSize(Integer.toString(vmd.getLogicalSizeInGB()));
                attacheableDataVirtualHardDisks.add(dvhds);
            }
            return attacheableDataVirtualHardDisks;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void detachStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="instanceId") @NotNull String instanceId, @ElementId(value="storageId") @NotNull String storageId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)"createInstance() start");
            AzureDetachStorage azureCreateInstance = new AzureDetachStorage(this.getConfiguration(), instanceId, storageId);
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureCreateInstance);
            } else {
                azureCreateInstance.execute();
            }
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)"createInstance() end");
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<InstanceInfo> getInstanceByCloudService(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="cloudServiceName") @Identity String cloudServiceName) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger logger = Logger.getLogger(this.getClass());
        ArrayList<InstanceInfo> instancesInfo = new ArrayList<InstanceInfo>();
        try {
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            HostedServiceOperations hostedServicesOperations = computeManagementClient.getHostedServicesOperations();
            DeploymentOperations deploymentOperations = computeManagementClient.getDeploymentsOperations();
            HostedServiceListResponse hostedServiceListResponse = hostedServicesOperations.list();
            for (HostedServiceListResponse.HostedService hostService : hostedServiceListResponse.getHostedServices()) {
                if (!hostService.getServiceName().equals(cloudServiceName)) continue;
                for (DeploymentSlot slot : AzureUtil.getDeploymentSlots()) {
                    DeploymentGetResponse deploymentGetResponse = null;
                    try {
                        deploymentGetResponse = deploymentOperations.getBySlot(hostService.getServiceName(), slot);
                    }
                    catch (ServiceException e) {
                        if (e.getErrorCode().equals("ResourceNotFound")) continue;
                        logger.error((Object)("getInstanceByCloudService: " + cloudServiceName + " (" + e.getErrorCode() + ") " + e.getMessage()));
                        throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
                    }
                    for (Role role : deploymentGetResponse.getRoles()) {
                        for (RoleInstance roleinstance : deploymentGetResponse.getRoleInstances()) {
                            if (!roleinstance.getRoleName().equalsIgnoreCase(role.getRoleName())) continue;
                            InstanceInfo instanceInfo = new InstanceInfo();
                            instanceInfo.setInstanceName(roleinstance.getRoleName());
                            instanceInfo.setDeploymentName(deploymentGetResponse.getName());
                            instanceInfo.setSize(role.getRoleSize());
                            instanceInfo.setOSType(role.getOSVirtualHardDisk().getOperatingSystem());
                            instanceInfo.setDiskNumber(role.getDataVirtualHardDisks().size());
                            instanceInfo.setAttachedLun(new ArrayList<Integer>());
                            for (DataVirtualHardDisk dvhd : role.getDataVirtualHardDisks()) {
                                instanceInfo.addAttachedLun(dvhd.getLogicalUnitNumber());
                            }
                            instanceInfo.setDataVirtualHardDisks(role.getDataVirtualHardDisks());
                            instanceInfo.setDataDiskAttachableNum(StorageSize.getAttachableMaxmum(role.getRoleSize()));
                            instancesInfo.add(instanceInfo);
                        }
                    }
                }
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("getInstanceByCloudService: " + cloudServiceName + " (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("getInstanceByCloudService: " + cloudServiceName + " " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return instancesInfo;
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public SnapShotInfo getSnapShotInfo(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="snapShotId") @Identity String snapShotId, @ElementId(value="storageId") @Identity String storageId) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger logger = Logger.getLogger(this.getClass());
        SnapShotInfo ssinfo = null;
        String storageAccountName = snapShotId.substring(0, snapShotId.indexOf("_"));
        String containerName = snapShotId.substring(snapShotId.indexOf("_") + 1);
        containerName = containerName.substring(0, containerName.indexOf("_"));
        String url = "";
        try {
            Configuration config = this.getConfiguration();
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
            StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            VirtualMachineDiskGetResponse vmd = computeManagementClient.getVirtualMachineDisksOperations().getDisk(storageId);
            Configuration blobconfig = null;
            blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
            BlobContract blobContract = BlobService.create((Configuration)blobconfig);
            GetBlobResult blobRes = blobContract.getBlob(containerName, snapShotId);
            url = AzureUtil.getVHDUrl(storageAccountName, containerName, snapShotId);
            if (blobRes != null) {
                ssinfo = new SnapShotInfo();
                ssinfo.setStorageAccountName(storageAccountName);
                ssinfo.setContainerName(containerName);
                ssinfo.setVHDFileName(snapShotId);
                ssinfo.setFileSize(vmd.getLogicalSizeInGB());
                ssinfo.setOSType(vmd.getOperatingSystemType());
                ssinfo.setUrl(url);
                return ssinfo;
            }
        }
        catch (ServiceException e) {
            logger.error((Object)("getSnapShotInfo: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("getSnapShotInfo: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return ssinfo;
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<String> getContainerByStorageAccount(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="storageAccountName") @Identity String storageAccountName) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ArrayList<String> containers = new ArrayList<String>();
        Logger logger = Logger.getLogger(this.getClass());
        try {
            Configuration config = this.getConfiguration();
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
            StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            StorageAccount sa = storageAccountOperations.get(storageAccountName).getStorageAccount();
            if (sa.getName().equals(storageAccountName)) {
                StorageAccountGetKeysResponse storageAccountGetKeysResponse = storageAccountOperations.getKeys(sa.getName());
                Configuration blobconfig = null;
                blobconfig = AzureUtil.getBlobConfiguration(sa.getName(), storageAccountGetKeysResponse.getPrimaryKey());
                BlobContract service = BlobService.create((Configuration)blobconfig);
                ListContainersResult listContainersResult = service.listContainers();
                for (ListContainersResult.Container container : listContainersResult.getContainers()) {
                    containers.add(container.getName());
                }
            }
            logger.info((Object)"Successful in getting Container by Storage Account ...");
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return containers;
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void deleteStorageBackup(@ElementId(value="storageBackupURL") @Identity String storageBackupURL) throws CloudManagerFault {
        StorageAccountOperations storageAccountOperations = null;
        Logger logger = Logger.getLogger(this.getClass());
        try {
            Configuration config = this.getConfiguration();
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
            storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            String storageAccountName = AzureUtil.getStorageAccountNameFromVHD(storageBackupURL);
            String containerName = AzureUtil.getContainerNameFromVHD(storageBackupURL);
            String vhdFileName = AzureUtil.getVHDFileNameFromVHD(storageBackupURL);
            AzureUtil.AzureServiceRequestFilter requestFilter = new AzureUtil.AzureServiceRequestFilter();
            AzureUtil.AzureServiceResponseFilter responseFilter = new AzureUtil.AzureServiceResponseFilter();
            Configuration blobconfig = null;
            blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
            BlobContract blobContract = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)requestFilter)).withResponseFilterLast((ServiceResponseFilter)responseFilter);
            blobContract.deleteBlob(containerName, vhdFileName);
            responseFilter.close();
            logger.info((Object)("deleteStorageBackup: RequestId:" + responseFilter.getRequestId()));
        }
        catch (ServiceException e) {
            logger.error((Object)("deleteStorageBackup: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("deleteStorageBackup: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudStorage restoreStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="SnapShotInfo") @NotNull @Into AzureRestoreStorageRequest restoreRequest) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger logger = Logger.getLogger(this.getClass());
        Configuration config = this.getConfiguration();
        ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
        VirtualMachineDiskOperations virtualMachineDiskOperations = computeManagementClient.getVirtualMachineDisksOperations();
        AzureUtil.AzureServiceRequestFilter request = new AzureUtil.AzureServiceRequestFilter();
        AzureUtil.AzureServiceResponseFilter response = new AzureUtil.AzureServiceResponseFilter();
        try {
            OperationStatusResponse operationStatusResponse;
            StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)config);
            StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
            VirtualMachineDiskGetResponse vmd = computeManagementClient.getVirtualMachineDisksOperations().getDisk(restoreRequest.getSourceDiskName());
            String storageAccountName = restoreRequest.getSnapShotInfo().getStorageAccountName();
            String containerName = restoreRequest.getSnapShotInfo().getContainerName();
            String vhdFileName = AzureUtil.getVHDFileNameFromVHD(vmd.getMediaLinkUri().toString());
            String snapshot = restoreRequest.getSnapShotInfo().getVHDFileName().replace(storageAccountName, "").replace(containerName, "").replace("_", "");
            snapshot = AzureUtil.getConvertSnapshotValue(snapshot);
            request.setHeader("x-ms-copy-source", "/" + storageAccountName + "/" + containerName + "/" + vhdFileName + "?snapshot=" + snapshot);
            Configuration blobconfig = null;
            blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
            BlobContract blobContract = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)request)).withResponseFilterLast((ServiceResponseFilter)response);
            String backUpName = vhdFileName + "_Restore";
            blobContract.createBlockBlob(containerName, backUpName, null);
            String url = AzureUtil.getVHDUrl(storageAccountName, containerName, backUpName);
            VirtualMachineDiskCreateParameters vmDiskParams = new VirtualMachineDiskCreateParameters();
            vmDiskParams.setOperatingSystemType(restoreRequest.getSnapShotInfo().getOSType());
            vmDiskParams.setMediaLinkUri(new URI(url));
            vmDiskParams.setLabel(restoreRequest.getDiskName());
            vmDiskParams.setName(restoreRequest.getDiskName());
            VirtualMachineDiskCreateResponse operationResponse = virtualMachineDiskOperations.createDisk(vmDiskParams);
            response.close();
            while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
            }
            logger.info((Object)("creating " + this.getClass().getSimpleName() + "..."));
            if (!operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                logger.error((Object)("failed in creating " + operationStatusResponse.getError()));
                throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
            }
            logger.info((Object)("successful in creating " + this.getClass().getSimpleName() + "..."));
        }
        catch (ServiceException e) {
            logger.error((Object)("restoreStorage: (" + e.getErrorCode() + ") " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("restoreStorage: " + e.getMessage()));
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public CloudStorage addStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="CreateStorageRequest") @NotNull @Into AzureCreateStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        AzureUtil.AzureServiceResponseFilter reponseFilter = null;
        try {
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            DeploymentGetResponse deploy = computeManagementClient.getDeploymentsOperations().getBySlot(request.getCloudServiceName(), DeploymentSlot.Production);
            VirtualMachineDataDiskCreateParameters vmDiskParams = new VirtualMachineDataDiskCreateParameters();
            vmDiskParams.setHostCaching(request.getVirtualHardDiskHostCaching());
            URI mediaLinkUri = new URI(AzureUtil.getVHDUrl(request.getStorageAccountName(), request.getContainerName(), request.getStorageName()));
            vmDiskParams.setMediaLinkUri(mediaLinkUri);
            vmDiskParams.setLogicalDiskSizeInGB(request.getStorageSize().intValue());
            vmDiskParams.setLogicalUnitNumber(Integer.valueOf(Integer.parseInt(request.getFlavor())));
            reponseFilter = new AzureUtil.AzureServiceResponseFilter();
            VirtualMachineDiskOperations virtualMachineDiskOperations = ((ComputeManagementClient)computeManagementClient.withResponseFilterLast((ServiceResponseFilter)reponseFilter)).getVirtualMachineDisksOperations();
            OperationResponse operationResponse = virtualMachineDiskOperations.createDataDisk(request.getCloudServiceName(), deploy.getName(), request.getInstanceName(), vmDiskParams);
            Logger logger = Logger.getLogger(this.getClass());
            logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
            OperationStatusResponse operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId());
            if (!operationStatusResponse.getStatus().equals((Object)OperationStatus.InProgress)) {
                logger.info((Object)("creating " + this.getClass().getSimpleName() + "..."));
                if (!operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                    logger.error((Object)("failed in creating " + operationStatusResponse.getError()));
                    throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
                }
                logger.info((Object)("successful in creating " + this.getClass().getSimpleName() + "..."));
            } else {
                AzureAsyncExecution.getSingleton().put(new AzureAsyncOperationStatus(computeManagementClient, operationResponse.getRequestId(), "VirtualMachineDiskOperations.createDataDisk((" + request.getCloudServiceName() + "," + deploy.getName() + "," + request.getInstanceName() + ")"));
            }
        }
        catch (ServiceException e) {
            if (reponseFilter != null && reponseFilter.getCalled() > 0) {
                switch (reponseFilter.getStatus()) {
                    case 200: 
                    case 201: 
                    case 202: {
                        return ((IStorageOperator)ResourceUtil.getResourceOperator(IStorageOperator.class)).createStorage((CreateStorageRequest)request);
                    }
                }
            }
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        reponseFilter.close();
        return ((IStorageOperator)ResourceUtil.getResourceOperator(IStorageOperator.class)).createStorage((CreateStorageRequest)request);
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public void atachStorage(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="storageId") @NotNull String storageId, @ElementId(value="CreateStorageRequest") @NotNull @Into AzureCreateStorageRequest request) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)"atachStorage() start");
            AzureAttachStorage azureAtachStorage = new AzureAttachStorage(this.getConfiguration(), storageId, request);
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureAtachStorage);
            } else {
                azureAtachStorage.execute();
            }
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)"atachStorage() end");
        }
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ, PrivilegeConstant.SystemPrivilegeMode.ADD})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public IResourceManagement.Instance createInstance(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="AzureCreateInstanceRequest") @NotNull @Into AzureCreateInstanceRequest createRequest) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        Logger logger = Logger.getLogger(this.getClass());
        try {
            logger.info((Object)"createInstance() start");
            ICloudContext context = (ICloudContext)SessionService.current().get(ICloudContext.class);
            AzureCreateInstance azureCreateInstance = new AzureCreateInstance(this.getConfiguration(), createRequest, region, context.getAccessDestionation().getCloudUser().getAccessKey());
            if (AzureOptionPropertyConstants.azure_api_mode.value().equalsIgnoreCase("async")) {
                AzureAsyncExecution.getSingleton().put(azureCreateInstance);
            } else {
                azureCreateInstance.execute();
            }
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.info((Object)"createInstance() end");
        }
        IResourceManagement.Instance instance = new IResourceManagement.Instance();
        return instance;
    }

    @Override
    @HinemosAccessRight(roleName="CloudManagement", right={PrivilegeConstant.SystemPrivilegeMode.READ})
    @CustomMethodValidation(value={AuthorizingValidator_role_region.class})
    public List<AzureImage> getImagesWithFilter(@ElementId(value="roleId") @Identity String roleId, @ElementId(value="region") @NotNull @Size(max=64) String region, @ElementId(value="filter") @Identity String filter) throws CloudManagerFault, InvalidUserPass, InvalidRole {
        ArrayList<AzureImage> images = new ArrayList<AzureImage>();
        try {
            AzureImage img;
            Configuration config = this.getConfiguration();
            ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)config);
            VirtualMachineOSImageListResponse virtualMachineOSImageListResponse = computeManagementClient.getVirtualMachineOSImagesOperations().list();
            for (VirtualMachineOSImageListResponse.VirtualMachineOSImage virtualMachineImage : virtualMachineOSImageListResponse.getImages()) {
                if (virtualMachineImage.getLocation() == null || !virtualMachineImage.getLocation().toLowerCase().contains(region.replace("-", " ")) || virtualMachineImage.getLabel() == null || !virtualMachineImage.getLabel().contains(filter)) continue;
                img = new AzureImage();
                img.setImageId(virtualMachineImage.getName());
                img.setName(virtualMachineImage.getLabel());
                img.setOStype(virtualMachineImage.getOperatingSystemType());
                images.add(img);
            }
            for (VirtualMachineOSImageListResponse.VirtualMachineOSImage virtualMachineImage : virtualMachineOSImageListResponse.getImages()) {
                if (virtualMachineImage.getLocation() != null || virtualMachineImage.getLabel() == null || !virtualMachineImage.getLabel().contains(filter)) continue;
                img = new AzureImage();
                img.setImageId(virtualMachineImage.getName());
                img.setName(virtualMachineImage.getLabel());
                img.setOStype(virtualMachineImage.getOperatingSystemType());
                images.add(img);
            }
        }
        catch (Exception e) {
            throw new CloudManagerFault(e.getMessage(), (Throwable)e);
        }
        return images;
    }

    public void start() {
    }

    public void stop() {
    }
}

