/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.util;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.AzureOptionPropertyConstants;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.proxy.IProxyStore;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.Builder;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestContext;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseContext;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.KeyStoreType;
import com.microsoft.windowsazure.management.ManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import com.microsoft.windowsazure.management.models.AffinityGroupListResponse;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class AzureUtil {
    public static final String targetsFilePath = "var/cloud/options/azure/tmp";

    public static Configuration getConfiguration(String accessKey, String secretKey) throws CloudManagerFault {
        return AzureUtil.getConfiguration(accessKey, secretKey, false);
    }

    public static Configuration getConfiguration(String accessKey, String secretKey, boolean checkMode) throws CloudManagerFault {
        Logger logger = Logger.getLogger(AzureUtil.class);
        Configuration config = null;
        try {
            String hinemosHome = System.getProperty("hinemos.manager.home.dir", "/opt/hinemos");
            File storeFile = new File(hinemosHome + "/" + targetsFilePath + "/" + (!checkMode ? accessKey : Long.valueOf(Thread.currentThread().getId())) + ".pfx");
            AzureUtil.createConfigurationStoreFile(storeFile, accessKey, secretKey);
            config = new Configuration();
            AzureUtil.setBuilder(config);
            config = ManagementConfiguration.configure(null, (Configuration)config, (URI)new URI(AzureOptionPropertyConstants.azure_base_uri.value()), (String)accessKey, (String)storeFile.toString(), (String)AzureOptionPropertyConstants.azure_pfx_storepass.value(), (KeyStoreType)KeyStoreType.fromString((String)AzureOptionPropertyConstants.azure_pfx_storetype.value()));
        }
        catch (IOException e) {
            logger.error((Object)("getConfiguration: " + e.getMessage()));
            throw new CloudManagerFault((Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error((Object)("getConfiguration: " + e.getMessage()));
            throw new CloudManagerFault((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("getConfiguration: " + e.getMessage()));
            throw new CloudManagerFault((Throwable)e);
        }
        return config;
    }

    public static void deleteConfiguration(String accessKey, String secretKey, boolean checkMode) {
        String hinemosHome = System.getProperty("hinemos.manager.home.dir", "/opt/hinemos");
        File storeFile = new File(hinemosHome + "/" + targetsFilePath + "/" + (!checkMode ? accessKey : Long.valueOf(Thread.currentThread().getId())) + ".pfx");
        if (storeFile.exists()) {
            storeFile.delete();
        }
    }

    public static void setBuilder(Configuration config) {
        int connectionTimeout = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_connectionTimeout.value());
        int readTimeout = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_readTimeout.value());
        if (connectionTimeout > 0 && readTimeout > 0) {
            config.setProperty("com.microsoft.windowsazure.Configuration.connectTimeout", (Object)AzureOptionPropertyConstants.azure_client_config_connectionTimeout.value());
            config.setProperty("com.microsoft.windowsazure.Configuration.readTimeout", (Object)AzureOptionPropertyConstants.azure_client_config_readTimeout.value());
        }
        String proxyHost = AzureOptionPropertyConstants.azure_client_config_proxyHost.value();
        int proxyPort = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_proxyPort.value());
        if (proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
            Builder.Registry builder = (Builder.Registry)config.getBuilder();
            builder.alter(ManagementClient.class, HttpClientBuilder.class, (Builder.Alteration)new Builder.Alteration<HttpClientBuilder>(){

                public HttpClientBuilder alter(String profile, HttpClientBuilder httpClientBuilder, Builder builder, Map<String, Object> properties) {
                    String proxyHost = AzureOptionPropertyConstants.azure_client_config_proxyHost.value();
                    int proxyPort = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_proxyPort.value());
                    if (proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
                        Logger logger = Logger.getLogger(AzureUtil.class);
                        logger.debug((Object)("Configuration(HttpClientBuilder): ManagementClient ProxyHost=" + proxyHost + ", ProxyPort=" + proxyPort));
                        httpClientBuilder.setProxy(new HttpHost(proxyHost, proxyPort, "http"));
                        String proxyUsername = AzureOptionPropertyConstants.azure_client_config_proxyUsername.value();
                        String proxyPassword = AzureOptionPropertyConstants.azure_client_config_proxyPassword.value();
                        if (proxyUsername != null && !proxyUsername.isEmpty() && proxyPassword != null && !proxyPassword.isEmpty()) {
                            BasicCredentialsProvider provider = new BasicCredentialsProvider();
                            AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
                            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                            provider.setCredentials(scope, (Credentials)credentials);
                            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
                        }
                    }
                    return httpClientBuilder;
                }
            });
            builder.alter(ComputeManagementClient.class, HttpClientBuilder.class, (Builder.Alteration)new Builder.Alteration<HttpClientBuilder>(){

                public HttpClientBuilder alter(String profile, HttpClientBuilder httpClientBuilder, Builder builder, Map<String, Object> properties) {
                    String proxyHost = AzureOptionPropertyConstants.azure_client_config_proxyHost.value();
                    int proxyPort = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_proxyPort.value());
                    if (proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
                        Logger logger = Logger.getLogger(AzureUtil.class);
                        logger.debug((Object)("Configuration(HttpClientBuilder): ComputeManagementClient ProxyHost=" + proxyHost + ", ProxyPort=" + proxyPort));
                        httpClientBuilder.setProxy(new HttpHost(proxyHost, proxyPort, "http"));
                        String proxyUsername = AzureOptionPropertyConstants.azure_client_config_proxyUsername.value();
                        String proxyPassword = AzureOptionPropertyConstants.azure_client_config_proxyPassword.value();
                        if (proxyUsername != null && !proxyUsername.isEmpty() && proxyPassword != null && !proxyPassword.isEmpty()) {
                            BasicCredentialsProvider provider = new BasicCredentialsProvider();
                            AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
                            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                            provider.setCredentials(scope, (Credentials)credentials);
                            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
                        }
                    }
                    return httpClientBuilder;
                }
            });
            builder.alter(StorageManagementClient.class, HttpClientBuilder.class, (Builder.Alteration)new Builder.Alteration<HttpClientBuilder>(){

                public HttpClientBuilder alter(String profile, HttpClientBuilder httpClientBuilder, Builder builder, Map<String, Object> properties) {
                    String proxyHost = AzureOptionPropertyConstants.azure_client_config_proxyHost.value();
                    int proxyPort = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_proxyPort.value());
                    if (proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
                        Logger logger = Logger.getLogger(AzureUtil.class);
                        logger.debug((Object)("Configuration(HttpClientBuilder): StorageManagementClient ProxyHost=" + proxyHost + ", ProxyPort=" + proxyPort));
                        httpClientBuilder.setProxy(new HttpHost(proxyHost, proxyPort, "http"));
                        String proxyUsername = AzureOptionPropertyConstants.azure_client_config_proxyUsername.value();
                        String proxyPassword = AzureOptionPropertyConstants.azure_client_config_proxyPassword.value();
                        if (proxyUsername != null && !proxyUsername.isEmpty() && proxyPassword != null && !proxyPassword.isEmpty()) {
                            BasicCredentialsProvider provider = new BasicCredentialsProvider();
                            AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
                            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                            provider.setCredentials(scope, (Credentials)credentials);
                            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
                        }
                    }
                    return httpClientBuilder;
                }
            });
        }
    }

    public static Configuration getBlobConfiguration(String saName, String primaryKey) throws CloudManagerFault {
        Logger logger = Logger.getLogger(AzureUtil.class);
        Configuration blobconfig = null;
        try {
            blobconfig = new Configuration();
            URI uri = new URI("https://" + saName + ".blob.core.windows.net/");
            blobconfig.setProperty("blob.accountName", (Object)saName);
            blobconfig.setProperty("blob.accountKey", (Object)primaryKey);
            blobconfig.setProperty("blob.uri", (Object)uri.toString());
            int connectionTimeout = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_connectionTimeout.value());
            int readTimeout = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_readTimeout.value());
            if (connectionTimeout > 0 && readTimeout > 0) {
                blobconfig.setProperty("com.microsoft.windowsazure.Configuration.connectTimeout", (Object)AzureOptionPropertyConstants.azure_client_config_connectionTimeout.value());
                blobconfig.setProperty("com.microsoft.windowsazure.Configuration.readTimeout", (Object)AzureOptionPropertyConstants.azure_client_config_readTimeout.value());
            }
            String proxyHost = AzureOptionPropertyConstants.azure_client_config_proxyHost.value();
            int proxyPort = Integer.valueOf(AzureOptionPropertyConstants.azure_client_config_proxyPort.value());
            if (proxyHost != null && !proxyHost.isEmpty() && proxyPort > 0) {
                logger.debug((Object)("BlobConfiguration(IProxyStore): ProxyHost=" + proxyHost + ", ProxyPort=" + proxyPort));
                String proxyUsername = AzureOptionPropertyConstants.azure_client_config_proxyUsername.value();
                String proxyPassword = AzureOptionPropertyConstants.azure_client_config_proxyPassword.value();
                IProxyStore proxyStore = (IProxyStore)ObjectRegistryService.registry().get(IProxyStore.class);
                if (proxyStore.getProxy(uri.getHost()) == null) {
                    ArrayList<String> destinations = new ArrayList<String>();
                    destinations.add(uri.getHost());
                    proxyStore.add(proxyHost, proxyPort, proxyUsername, proxyPassword, destinations.toArray(new String[destinations.size()]));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("getBlobConfiguration: " + e.getMessage()));
            throw new CloudManagerFault((Throwable)e);
        }
        return blobconfig;
    }

    public static boolean compareLocation(String regionName, String hostServiceName, String affinityGroupName, ArrayList<AffinityGroupListResponse.AffinityGroup> affinityGroup\uff53) {
        if (hostServiceName != null && !hostServiceName.equals("")) {
            return hostServiceName.replace(' ', '-').equalsIgnoreCase(regionName.replace(' ', '-'));
        }
        for (AffinityGroupListResponse.AffinityGroup affinityGroup : affinityGroup\uff53) {
            if (!affinityGroupName.equals(affinityGroup.getName()) || !affinityGroup.getLocation().replace(' ', '-').equalsIgnoreCase(regionName.replace(' ', '-'))) continue;
            return true;
        }
        return false;
    }

    public static boolean compareLocation(String regionName, String hostServiceName, ArrayList<AffinityGroupListResponse.AffinityGroup> affinityGroup\uff53) {
        if (hostServiceName != null && !hostServiceName.equals("")) {
            return hostServiceName.replace(' ', '-').equalsIgnoreCase(regionName.replace(' ', '-'));
        }
        for (AffinityGroupListResponse.AffinityGroup affinityGroup : affinityGroup\uff53) {
            if (!affinityGroup.getLocation().replace(' ', '-').equalsIgnoreCase(regionName.replace(' ', '-'))) continue;
            return true;
        }
        return false;
    }

    public static List<DeploymentSlot> getDeploymentSlots() {
        ArrayList<DeploymentSlot> slots = new ArrayList<DeploymentSlot>();
        for (String str : AzureOptionPropertyConstants.azure_deployment_slots.value().split(",")) {
            if (DeploymentSlot.Production.toString().equalsIgnoreCase(str)) {
                slots.add(DeploymentSlot.Production);
            }
            if (!DeploymentSlot.Staging.toString().equalsIgnoreCase(str)) continue;
            slots.add(DeploymentSlot.Staging);
        }
        if (slots.isEmpty()) {
            slots.add(DeploymentSlot.Production);
            slots.add(DeploymentSlot.Staging);
        }
        return slots;
    }

    public static String getStorageAccountNameFromVHD(String uri) {
        String storageAccountName = uri;
        storageAccountName = storageAccountName.replace("https://", "").replace("http://", "");
        storageAccountName = storageAccountName.substring(0, storageAccountName.indexOf("."));
        return storageAccountName;
    }

    public static String getContainerNameFromVHD(String uri) {
        String containerName = uri;
        containerName = containerName.replace("https://", "").replace("http://", "");
        containerName = containerName.substring(containerName.indexOf("/") + 1);
        containerName = containerName.substring(0, containerName.indexOf("/"));
        return containerName;
    }

    public static String getVHDFileNameFromVHD(String uri) {
        String vhdFileName = uri;
        vhdFileName = vhdFileName.replace("https://", "").replace("http://", "");
        vhdFileName = vhdFileName.substring(vhdFileName.indexOf("/") + 1);
        vhdFileName = vhdFileName.substring(vhdFileName.indexOf("/") + 1);
        return vhdFileName;
    }

    public static String getVHDUrl(String storageAccountName, String containerName, String storageName) {
        if (storageName.toLowerCase().lastIndexOf(".vhd") < 0) {
            storageName = storageName + ".vhd";
        }
        return "https://" + storageAccountName + ".blob.core.windows.net/" + containerName + "/" + storageName;
    }

    public static String getConvertSnapshotId(String snapshot) {
        return snapshot == null ? null : snapshot.replaceAll("[A-Z,a-z,:,/,.,\\-]", "");
    }

    public static String getConvertSnapshotValue(String snapshotId) {
        if (snapshotId == null) {
            return null;
        }
        return snapshotId.substring(0, 4) + "-" + snapshotId.substring(4, 6) + "-" + snapshotId.substring(6, 8) + "T" + snapshotId.substring(8, 10) + ":" + snapshotId.substring(10, 12) + ":" + snapshotId.substring(12, 14) + "." + snapshotId.substring(14) + "Z";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createConfigurationStoreFile(File storeFile, String accessKey, String secretKey) throws CloudManagerFault {
        byte[] storeKey = Base64.decodeBase64((String)secretKey);
        File storeDir = storeFile.getParentFile();
        if (!storeDir.exists()) {
            storeDir.mkdirs();
        }
        if (storeFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(storeFile);
                byte[] data = new byte[8192];
                int len = fis.read(data);
                fis.close();
                fis = null;
                if (len <= 0 || len >= 8192) {
                    storeFile.delete();
                } else {
                    byte[] compareKey = Arrays.copyOfRange(data, 0, len);
                    if (!Arrays.equals(storeKey, compareKey)) {
                        storeFile.delete();
                    }
                }
            }
            catch (IOException e) {
                storeFile.delete();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                    fis = null;
                }
            }
        }
        if (!storeFile.exists()) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(storeFile, false);
                fos.write(storeKey);
                fos.flush();
                fos.close();
                fos = null;
            }
            catch (IOException e) {
                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                    fos = null;
                }
            }
        }
    }

    public static class AzureServiceRequestFilter
    implements ServiceRequestFilter {
        private int called = 0;
        private int response_status = 0;
        private String x_ms_request_id = null;
        private String key_param = null;
        private String key_value = null;
        private String org_url = null;
        private String new_url = null;

        public int getCalled() {
            return this.called;
        }

        public int getStatus() {
            return this.response_status;
        }

        public String getRequestId() {
            return this.x_ms_request_id;
        }

        public void setHeader(String param, String value) {
            this.key_param = param;
            this.key_value = value;
        }

        public void changeURL(String org_url, String new_url) {
            this.org_url = org_url;
            this.new_url = new_url;
        }

        public void filter(ServiceRequestContext request) {
            if (this.key_param != null) {
                request.setHeader(this.key_param, this.key_value);
            }
            if (this.org_url != null) {
                String url = request.getURI().toString().replace(this.org_url, this.new_url);
                try {
                    request.setURI(new URI(url));
                }
                catch (URISyntaxException e) {
                    Logger logger = Logger.getLogger(AzureUtil.class);
                    logger.error((Object)("filter(ServiceRequestContext): url=(" + url + ") " + e.getMessage()));
                }
            }
        }
    }

    public static class AzureServiceResponseFilter
    implements ServiceResponseFilter {
        private FileInputStream fis1 = null;
        private FileInputStream fis2 = null;
        private boolean isUseBody = false;
        private int called = 0;
        private int response_status = 0;
        private String x_ms_request_id = null;
        private String x_ms_snapshot = null;

        public int getCalled() {
            return this.called;
        }

        public int getStatus() {
            return this.response_status;
        }

        public String getRequestId() {
            return this.x_ms_request_id;
        }

        public String getSnapShot() {
            return this.x_ms_snapshot;
        }

        public void setUseBody() {
            this.isUseBody = true;
        }

        public void filter(ServiceRequestContext request, ServiceResponseContext response) {
            ++this.called;
            this.response_status = response.getStatus();
            if (response.getHeader("x-ms-request-id") != null) {
                this.x_ms_request_id = response.getHeader("x-ms-request-id");
            }
            if (response.getHeader("x-ms-snapshot") != null) {
                this.x_ms_snapshot = response.getHeader("x-ms-snapshot");
            }
            if (this.isUseBody && this.response_status == 200) {
                try {
                    int len;
                    String hinemosHome = System.getProperty("hinemos.manager.home.dir", "/opt/hinemos");
                    File storeFile = new File(hinemosHome + "/" + AzureUtil.targetsFilePath + "/" + Thread.currentThread().getId() + ".xml");
                    File storeDir = storeFile.getParentFile();
                    if (!storeDir.exists()) {
                        storeDir.mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(storeFile);
                    byte[] buffer = new byte[10240];
                    while ((len = response.getEntityInputStream().read(buffer)) >= 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.flush();
                    fos.close();
                    this.fis1 = new FileInputStream(storeFile);
                    this.fis2 = new FileInputStream(storeFile);
                    response.setEntityInputStream((InputStream)this.fis1);
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(AzureUtil.class);
                    logger.error((Object)("FileOutputStream: " + e.getMessage()));
                }
            }
        }

        public InputStream getInputStream() {
            return this.fis2;
        }

        public void close() {
            Logger logger;
            if (this.fis1 != null) {
                try {
                    this.fis1.close();
                }
                catch (IOException e) {
                    logger = Logger.getLogger(AzureUtil.class);
                    logger.error((Object)("close: " + e.getMessage()));
                }
                this.fis1 = null;
            }
            if (this.fis2 != null) {
                try {
                    this.fis2.close();
                }
                catch (IOException e) {
                    logger = Logger.getLogger(AzureUtil.class);
                    logger.error((Object)("close: " + e.getMessage()));
                }
                this.fis2 = null;
            }
        }
    }
}

