/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.factory;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.azure.bean.AzureCreateInstanceRequest;
import com.clustercontrol.cloud.azure.bean.AzurePendingInstances;
import com.clustercontrol.cloud.azure.factory.AzureAsyncOperations;
import com.clustercontrol.cloud.azure.util.AzureUtil;
import com.clustercontrol.ws.azure.EndPoint;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.VirtualMachineDiskOperations;
import com.microsoft.windowsazure.management.compute.models.ConfigurationSet;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.InputEndpoint;
import com.microsoft.windowsazure.management.compute.models.OSVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.VirtualHardDiskHostCaching;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDataDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineDiskCreateParameters;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineOSImageGetResponse;
import com.microsoft.windowsazure.management.storage.StorageAccountOperations;
import com.microsoft.windowsazure.management.storage.StorageManagementClient;
import com.microsoft.windowsazure.management.storage.StorageManagementService;
import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.BlobService;
import com.microsoft.windowsazure.services.blob.models.GetBlobResult;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class AzureCreateInstance
extends AzureAsyncOperations {
    private Logger logger = Logger.getLogger(this.getClass());
    private Configuration config = null;
    private AzureCreateInstanceRequest azureCreateInstanceRequest = null;
    private String regionName = "";
    private String accessKey = "";

    public AzureCreateInstance(Configuration config, AzureCreateInstanceRequest azureCreateInstanceRequest, String regionName, String accessKey) {
        this.config = config;
        this.azureCreateInstanceRequest = azureCreateInstanceRequest;
        this.regionName = regionName;
        this.accessKey = accessKey;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws CloudManagerFault {
        block51: {
            String exec_type = this.azureCreateInstanceRequest.isRestore() ? "RestoreInstance" : "CreateInstance";
            try {
                OperationStatusResponse operationStatusResponse;
                String backUpName;
                BlobContract blobContract_restore;
                Configuration blobconfig_restore;
                String restoreDisk;
                int i;
                OperationStatusResponse operationStatusResponse2;
                this.logger.info((Object)("AzureCreateInstance() start: type=" + (this.azureCreateInstanceRequest.isRestore() ? "Restore" : "Create") + " " + this.azureCreateInstanceRequest.getNodeDetail().getNodeName()));
                ComputeManagementClient computeManagementClient = ComputeManagementService.create((Configuration)this.config);
                StorageManagementClient storageManagementClient = StorageManagementService.create((Configuration)this.config);
                DeploymentGetResponse deploy = computeManagementClient.getDeploymentsOperations().getBySlot(this.azureCreateInstanceRequest.getCloudServiceName(), DeploymentSlot.Production);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date nowDate = new Date();
                String diskname = this.azureCreateInstanceRequest.getCloudServiceName() + "-" + deploy.getName() + "-hinemos-" + sdf.format(nowDate);
                String url = AzureUtil.getVHDUrl(this.azureCreateInstanceRequest.getStorageAccountName(), this.azureCreateInstanceRequest.getContainerName(), diskname);
                OSVirtualHardDisk oSVirtualHardDisk = new OSVirtualHardDisk();
                oSVirtualHardDisk.setName(diskname);
                oSVirtualHardDisk.setHostCaching(VirtualHardDiskHostCaching.ReadWrite);
                oSVirtualHardDisk.setOperatingSystem(this.azureCreateInstanceRequest.getOSType());
                oSVirtualHardDisk.setMediaLink(new URI(url));
                oSVirtualHardDisk.setSourceImageName(this.azureCreateInstanceRequest.getImage().getImageId());
                ArrayList<ConfigurationSet> configlist = new ArrayList<ConfigurationSet>();
                ConfigurationSet configset = new ConfigurationSet();
                if (this.azureCreateInstanceRequest.getImage().getOStype().toLowerCase().equals("windows")) {
                    configset.setConfigurationSetType("WindowsProvisioningConfiguration");
                    configset.setComputerName(this.azureCreateInstanceRequest.getNodeDetail().getNodeName());
                    configset.setAdminPassword(this.azureCreateInstanceRequest.getPassWord());
                    configset.setAdminUserName(this.azureCreateInstanceRequest.getAccountName());
                    configset.setEnableAutomaticUpdates(Boolean.valueOf(false));
                } else {
                    configset.setConfigurationSetType("LinuxProvisioningConfiguration");
                    configset.setComputerName(this.azureCreateInstanceRequest.getNodeDetail().getNodeName());
                    configset.setHostName(this.azureCreateInstanceRequest.getNodeDetail().getNodeName());
                    configset.setUserName(this.azureCreateInstanceRequest.getAccountName());
                    configset.setUserPassword(this.azureCreateInstanceRequest.getPassWord());
                    configset.setDisableSshPasswordAuthentication(Boolean.valueOf(false));
                }
                configlist.add(configset);
                configset = new ConfigurationSet();
                ArrayList<InputEndpoint> inputEndpointsValue = new ArrayList<InputEndpoint>();
                if (this.azureCreateInstanceRequest.getEndPoint() != null) {
                    for (EndPoint ep : this.azureCreateInstanceRequest.getEndPoint()) {
                        InputEndpoint iep = new InputEndpoint();
                        iep.setName(ep.getName());
                        iep.setProtocol(ep.getProtocol());
                        if (ep.getPublicPort() != null) {
                            iep.setPort(ep.getPublicPort());
                        }
                        iep.setLocalPort(ep.getPrivatePort());
                        inputEndpointsValue.add(iep);
                    }
                }
                if (!inputEndpointsValue.isEmpty()) {
                    configset.setConfigurationSetType("NetworkConfiguration");
                    configset.setInputEndpoints(inputEndpointsValue);
                    configlist.add(configset);
                }
                VirtualMachineCreateParameters createParameters = new VirtualMachineCreateParameters();
                createParameters.setRoleName(this.azureCreateInstanceRequest.getNodeDetail().getNodeName());
                createParameters.setRoleSize(this.azureCreateInstanceRequest.getSize());
                createParameters.setProvisionGuestAgent(Boolean.valueOf(true));
                createParameters.setConfigurationSets(configlist);
                createParameters.setOSVirtualHardDisk(oSVirtualHardDisk);
                if (this.azureCreateInstanceRequest.getAvailabilitySet().booleanValue()) {
                    createParameters.setAvailabilitySetName(this.azureCreateInstanceRequest.getAvailabilitySetName());
                }
                this.logger.info((Object)("ComputeManagementClient.getVirtualMachinesOperations().create(" + this.azureCreateInstanceRequest.getCloudServiceName() + "," + deploy.getName() + ")"));
                this.logger.info((Object)("params=" + this.azureCreateInstanceRequest.getNodeDetail().getNodeName() + ": " + this.azureCreateInstanceRequest.getImage().getDescription() + " " + this.azureCreateInstanceRequest.getSize() + " " + this.azureCreateInstanceRequest.getImage().getImageId()));
                this.logger.info((Object)("params=" + this.azureCreateInstanceRequest.getNodeDetail().getNodeName() + ": " + this.azureCreateInstanceRequest.getStorageAccountName() + " " + this.azureCreateInstanceRequest.getContainerName() + " " + diskname));
                OperationStatusResponse operationResponse = computeManagementClient.getVirtualMachinesOperations().create(this.azureCreateInstanceRequest.getCloudServiceName(), deploy.getName(), createParameters);
                this.logger.info((Object)("RequestId:" + operationResponse.getRequestId()));
                while ((operationStatusResponse2 = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                }
                this.logger.info((Object)("creating " + this.getClass().getSimpleName() + "..."));
                if (!operationStatusResponse2.getStatus().equals((Object)OperationStatus.Succeeded)) {
                    this.logger.error((Object)("failed in creating " + operationStatusResponse2.getError()));
                    this.putLog(exec_type, exec_type + " was failed", operationStatusResponse2.getError().getMessage());
                    throw new CloudManagerFault(operationStatusResponse2.getError().getMessage(), (Throwable)new Exception(operationStatusResponse2.getError().getCode()));
                }
                this.logger.info((Object)("successful in creating " + this.getClass().getSimpleName() + "..."));
                AzureUtil.AzureServiceRequestFilter request = new AzureUtil.AzureServiceRequestFilter();
                AzureUtil.AzureServiceResponseFilter response = new AzureUtil.AzureServiceResponseFilter();
                StorageAccountOperations storageAccountOperations = storageManagementClient.getStorageAccountsOperations();
                VirtualMachineDiskOperations virtualMachineDiskOperations = ((ComputeManagementClient)computeManagementClient.withResponseFilterLast((ServiceResponseFilter)response)).getVirtualMachineDisksOperations();
                Configuration blobconfig = null;
                BlobContract blobContract = null;
                VirtualMachineOSImageGetResponse vmImage = computeManagementClient.getVirtualMachineOSImagesOperations().get(this.azureCreateInstanceRequest.getImage().getImageId());
                if (vmImage.getMediaLinkUri() == null) break block51;
                String uri = vmImage.getMediaLinkUri().toString();
                String storageAccountName = AzureUtil.getStorageAccountNameFromVHD(uri);
                String containerName = AzureUtil.getContainerNameFromVHD(uri);
                String vhdFileName = AzureUtil.getVHDFileNameFromVHD(uri);
                blobconfig = AzureUtil.getBlobConfiguration(storageAccountName, storageAccountOperations.getKeys(storageAccountName).getPrimaryKey());
                blobContract = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig).withRequestFilterLast((ServiceRequestFilter)request)).withResponseFilterLast((ServiceResponseFilter)response);
                GetBlobResult blobRes = blobContract.getBlob(containerName, vhdFileName);
                block34: for (i = 0; i <= 15 && blobRes.getMetadata() != null; ++i) {
                    restoreDisk = (String)blobRes.getMetadata().get("LUN" + Integer.toString(i));
                    if (restoreDisk == null) continue;
                    request.setHeader("x-ms-copy-source", "/" + AzureUtil.getStorageAccountNameFromVHD(restoreDisk) + "/" + AzureUtil.getContainerNameFromVHD(restoreDisk) + "/" + AzureUtil.getVHDFileNameFromVHD(restoreDisk));
                    blobconfig_restore = null;
                    blobconfig_restore = AzureUtil.getBlobConfiguration(AzureUtil.getStorageAccountNameFromVHD(restoreDisk), storageAccountOperations.getKeys(AzureUtil.getStorageAccountNameFromVHD(restoreDisk)).getPrimaryKey());
                    blobContract_restore = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig_restore).withRequestFilterLast((ServiceRequestFilter)request)).withResponseFilterLast((ServiceResponseFilter)response);
                    backUpName = "";
                    int ind = vhdFileName.toLowerCase().lastIndexOf(".vhd");
                    backUpName = ind > 0 ? vhdFileName.substring(0, ind) + "_Restore_" + sdf.format(new Date()) + ".vhd" : vhdFileName + "_Restore_" + sdf.format(new Date()) + ".vhd";
                    this.logger.info((Object)("BlobContract.createBlockBlob(" + containerName + "," + backUpName + ")"));
                    blobContract_restore.createBlockBlob(containerName, backUpName, null);
                    this.logger.info((Object)"successful in createBlockBlob");
                    VirtualMachineDiskCreateParameters vmDiskParams = new VirtualMachineDiskCreateParameters();
                    vmDiskParams.setMediaLinkUri(new URI(uri.substring(0, uri.indexOf(vhdFileName)) + backUpName));
                    vmDiskParams.setLabel(this.azureCreateInstanceRequest.getCloudServiceName() + "-" + deploy.getName() + "-hinemos-" + sdf.format(new Date()));
                    vmDiskParams.setName(this.azureCreateInstanceRequest.getCloudServiceName() + "-" + deploy.getName() + "-hinemos-" + sdf.format(new Date()));
                    try {
                        this.logger.info((Object)("VirtualMachineDiskOperations.createDisk(" + vmDiskParams.getName() + ")"));
                        virtualMachineDiskOperations.createDisk(vmDiskParams);
                        this.logger.info((Object)"successful in createDisk");
                    }
                    catch (ServiceException e) {
                        if (response == null) throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        if (response.getCalled() <= 0) throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        switch (response.getStatus()) {
                            case 200: {
                                this.logger.info((Object)"successful in createDisk");
                                continue block34;
                            }
                            case 201: 
                            case 202: {
                                while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                                }
                                this.logger.info((Object)("createDisk " + this.getClass().getSimpleName() + "..."));
                                if (!operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                                    this.logger.error((Object)("failed in createDisk " + operationStatusResponse.getError()));
                                    this.putLog(exec_type, exec_type + " was failed", operationStatusResponse.getError().getMessage());
                                    throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
                                }
                                this.logger.info((Object)("successful in createDisk " + this.getClass().getSimpleName() + "..."));
                                continue block34;
                            }
                            default: {
                                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    VirtualMachineDataDiskCreateParameters parameters = new VirtualMachineDataDiskCreateParameters();
                    parameters.setHostCaching(VirtualHardDiskHostCaching.None);
                    parameters.setName(vmDiskParams.getName());
                    parameters.setMediaLinkUri(new URI(uri.substring(0, uri.indexOf(vhdFileName)) + backUpName));
                    parameters.setLogicalUnitNumber(Integer.valueOf(i));
                    try {
                        this.logger.info((Object)("VirtualMachineDiskOperations.createDataDisk(" + deploy.getName() + "," + deploy.getName() + this.azureCreateInstanceRequest.getNodeDetail().getNodeName() + ")"));
                        virtualMachineDiskOperations.createDataDisk(this.azureCreateInstanceRequest.getCloudServiceName(), deploy.getName(), this.azureCreateInstanceRequest.getNodeDetail().getNodeName(), parameters);
                        this.logger.info((Object)"successful in createDataDisk");
                        continue;
                    }
                    catch (ServiceException e) {
                        if (response == null) throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        if (response.getCalled() <= 0) throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        switch (response.getStatus()) {
                            case 200: {
                                continue block34;
                            }
                            case 201: 
                            case 202: {
                                OperationStatusResponse operationStatusResponse3;
                                while ((operationStatusResponse3 = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                                }
                                this.logger.info((Object)("createDataDisk " + this.getClass().getSimpleName() + "..."));
                                if (!operationStatusResponse3.getStatus().equals((Object)OperationStatus.Succeeded)) {
                                    this.logger.error((Object)("failed in createDataDisk " + operationStatusResponse3.getError()));
                                    this.putLog(exec_type, exec_type + " was failed", operationStatusResponse3.getError().getMessage());
                                    throw new CloudManagerFault(operationStatusResponse3.getError().getMessage(), (Throwable)new Exception(operationStatusResponse3.getError().getCode()));
                                }
                                this.logger.info((Object)("successful in createDataDisk " + this.getClass().getSimpleName() + "..."));
                                continue block34;
                            }
                            default: {
                                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                block37: for (i = 0; i <= 15 && blobRes.getMetadata() != null; ++i) {
                    restoreDisk = (String)blobRes.getMetadata().get("LUNNULL" + Integer.toString(i));
                    if (restoreDisk == null) continue;
                    request.setHeader("x-ms-copy-source", "/" + AzureUtil.getStorageAccountNameFromVHD(restoreDisk) + "/" + AzureUtil.getContainerNameFromVHD(restoreDisk) + "/" + AzureUtil.getVHDFileNameFromVHD(restoreDisk));
                    blobconfig_restore = null;
                    blobconfig_restore = AzureUtil.getBlobConfiguration(AzureUtil.getStorageAccountNameFromVHD(restoreDisk), storageAccountOperations.getKeys(AzureUtil.getStorageAccountNameFromVHD(restoreDisk)).getPrimaryKey());
                    blobContract_restore = (BlobContract)((BlobContract)BlobService.create((Configuration)blobconfig_restore).withRequestFilterLast((ServiceRequestFilter)request)).withResponseFilterLast((ServiceResponseFilter)response);
                    backUpName = vhdFileName + "_Restore_" + sdf.format(new Date()) + ".vhd";
                    this.logger.info((Object)("blobContract.createBlockBlob(" + containerName + "," + backUpName + ")"));
                    blobContract_restore.createBlockBlob(containerName, backUpName, null);
                    this.logger.info((Object)"successful in createBlockBlob");
                    VirtualMachineDiskCreateParameters vmDiskParams = new VirtualMachineDiskCreateParameters();
                    vmDiskParams.setMediaLinkUri(new URI(uri.substring(0, uri.indexOf(vhdFileName)) + backUpName));
                    vmDiskParams.setLabel(this.azureCreateInstanceRequest.getCloudServiceName() + "-" + deploy.getName() + "-hinemos-" + sdf.format(new Date()));
                    vmDiskParams.setName(this.azureCreateInstanceRequest.getCloudServiceName() + "-" + deploy.getName() + "-hinemos-" + sdf.format(new Date()));
                    try {
                        this.logger.info((Object)("VirtualMachineDiskOperations.createDisk(" + vmDiskParams.getName() + ")"));
                        virtualMachineDiskOperations.createDisk(vmDiskParams);
                        this.logger.info((Object)"successful in createDisk");
                    }
                    catch (ServiceException e) {
                        if (response == null) throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        if (response.getCalled() <= 0) throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        switch (response.getStatus()) {
                            case 200: {
                                continue block37;
                            }
                            case 201: 
                            case 202: {
                                OperationStatusResponse operationStatusResponse4;
                                while ((operationStatusResponse4 = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                                }
                                this.logger.info((Object)("createDisk " + this.getClass().getSimpleName() + "..."));
                                if (!operationStatusResponse4.getStatus().equals((Object)OperationStatus.Succeeded)) {
                                    this.logger.error((Object)("failed in createDisk " + operationStatusResponse4.getError()));
                                    this.putLog(exec_type, exec_type + " was failed", operationStatusResponse4.getError().getMessage());
                                    throw new CloudManagerFault(operationStatusResponse4.getError().getMessage(), (Throwable)new Exception(operationStatusResponse4.getError().getCode()));
                                }
                                this.logger.info((Object)("successful in createDisk " + this.getClass().getSimpleName() + "..."));
                                continue block37;
                            }
                            default: {
                                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    VirtualMachineDataDiskCreateParameters parameters = new VirtualMachineDataDiskCreateParameters();
                    parameters.setHostCaching(VirtualHardDiskHostCaching.None);
                    parameters.setName(vmDiskParams.getName());
                    parameters.setMediaLinkUri(new URI(uri.substring(0, uri.indexOf(vhdFileName)) + backUpName));
                    try {
                        this.logger.info((Object)("VirtualMachineDiskOperations.createDataDisk(" + this.azureCreateInstanceRequest.getCloudServiceName() + "," + deploy.getName() + "," + this.azureCreateInstanceRequest.getNodeDetail().getNodeName() + ")"));
                        virtualMachineDiskOperations.createDataDisk(this.azureCreateInstanceRequest.getCloudServiceName(), deploy.getName(), this.azureCreateInstanceRequest.getNodeDetail().getNodeName(), parameters);
                        this.logger.info((Object)"successful in createDataDisk");
                        continue;
                    }
                    catch (ServiceException e) {
                        if (response == null) throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        if (response.getCalled() <= 0) throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                        switch (response.getStatus()) {
                            case 200: {
                                this.logger.info((Object)"successful in createDataDisk");
                                continue block37;
                            }
                            case 201: 
                            case 202: {
                                while ((operationStatusResponse = computeManagementClient.getOperationStatus(operationResponse.getRequestId())).getStatus().equals((Object)OperationStatus.InProgress)) {
                                }
                                this.logger.info((Object)("createDataDisk " + this.getClass().getSimpleName() + "..."));
                                if (!operationStatusResponse.getStatus().equals((Object)OperationStatus.Succeeded)) {
                                    this.logger.error((Object)("failed in createDataDisk " + operationStatusResponse.getError()));
                                    this.putLog(exec_type, exec_type + " was failed", operationStatusResponse.getError().getMessage());
                                    throw new CloudManagerFault(operationStatusResponse.getError().getMessage(), (Throwable)new Exception(operationStatusResponse.getError().getCode()));
                                }
                                this.logger.info((Object)("successful in createDataDisk " + this.getClass().getSimpleName() + "..."));
                                continue block37;
                            }
                            default: {
                                throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                try {
                    this.logger.error((Object)("AzureCreateInstance:execute() IOException:" + e.getMessage()));
                    this.putLog(exec_type, exec_type + " was failed", e.getMessage());
                    throw new CloudManagerFault(e.getMessage(), (Throwable)e);
                    catch (ServiceException e2) {
                        this.logger.error((Object)("AzureCreateInstance:execute() ServiceException:" + e2.getMessage()));
                        this.putLog(exec_type, exec_type + " was failed", e2.getMessage());
                        throw new CloudManagerFault(e2.getMessage(), (Throwable)e2);
                    }
                    catch (ParserConfigurationException e3) {
                        this.logger.error((Object)("AzureCreateInstance:execute() ParserConfigurationException:" + e3.getMessage()));
                        this.putLog(exec_type, exec_type + " was failed", e3.getMessage());
                        throw new CloudManagerFault(e3.getMessage(), (Throwable)e3);
                    }
                    catch (SAXException e4) {
                        this.logger.error((Object)("AzureCreateInstance:execute() SAXException:" + e4.getMessage()));
                        this.putLog(exec_type, exec_type + " was failed", e4.getMessage());
                        throw new CloudManagerFault(e4.getMessage(), (Throwable)e4);
                    }
                    catch (Exception e5) {
                        this.logger.error((Object)("AzureCreateInstance:execute() Exception:" + e5.getMessage()));
                        this.putLog(exec_type, exec_type + " was failed", e5.getMessage());
                        throw new CloudManagerFault(e5.getMessage(), (Throwable)e5);
                    }
                }
                catch (Throwable throwable) {
                    AzurePendingInstances cond = AzurePendingInstances.getInstance();
                    cond.removeAzureInstance(this.azureCreateInstanceRequest.getNodeDetail().getNodeName(), this.regionName, this.accessKey);
                    this.logger.info((Object)("AzureCreateInstance:execute() end: type=" + (this.azureCreateInstanceRequest.isRestore() ? "Restore" : "Create") + " " + this.azureCreateInstanceRequest.getNodeDetail().getNodeName()));
                    throw throwable;
                }
            }
        }
        AzurePendingInstances cond = AzurePendingInstances.getInstance();
        cond.removeAzureInstance(this.azureCreateInstanceRequest.getNodeDetail().getNodeName(), this.regionName, this.accessKey);
        this.logger.info((Object)("AzureCreateInstance:execute() end: type=" + (this.azureCreateInstanceRequest.isRestore() ? "Restore" : "Create") + " " + this.azureCreateInstanceRequest.getNodeDetail().getNodeName()));
    }
}

