/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.content.AssetFileType;
import com.microsoft.windowsazure.services.media.models.AssetFileInfo;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.sun.jersey.api.client.GenericType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class AssetFile {
    private static final String ENTITY_SET = "Files";

    private AssetFile() {
    }

    public static Creator create(String parentAssetId, String name) {
        return new Creator(parentAssetId, name);
    }

    public static EntityActionOperation createFileInfos(String assetId) {
        String encodedId;
        try {
            encodedId = URLEncoder.encode(assetId, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return new DefaultActionOperation("CreateFileInfos").addQueryParameter("assetid", "'" + encodedId + "'");
    }

    public static EntityGetOperation<AssetFileInfo> get(String assetFileId) {
        return new DefaultGetOperation<AssetFileInfo>(ENTITY_SET, assetFileId, AssetFileInfo.class);
    }

    public static DefaultListOperation<AssetFileInfo> list() {
        return new DefaultListOperation<AssetFileInfo>(ENTITY_SET, new GenericType<ListResult<AssetFileInfo>>(){});
    }

    public static DefaultListOperation<AssetFileInfo> list(LinkInfo<AssetFileInfo> link) {
        return new DefaultListOperation<AssetFileInfo>(link.getHref(), new GenericType<ListResult<AssetFileInfo>>(){});
    }

    public static Updater update(String assetFileId) {
        return new Updater(assetFileId);
    }

    public static EntityDeleteOperation delete(String assetFileId) {
        return new DefaultDeleteOperation(ENTITY_SET, assetFileId);
    }

    public static final class Updater
    extends EntityOperationBase
    implements EntityUpdateOperation {
        private String contentChecksum;
        private Long contentFileSize;
        private String encryptionKeyId;
        private String encryptionScheme;
        private String encryptionVersion;
        private String initializationVector;
        private Boolean isEncrypted;
        private Boolean isPrimary;
        private String mimeType;

        private Updater(String assetFileId) {
            super(new EntityOperationBase.EntityIdUriBuilder(AssetFile.ENTITY_SET, assetFileId));
        }

        @Override
        public Object getRequestContents() {
            return new AssetFileType().setContentChecksum(this.contentChecksum).setContentFileSize(this.contentFileSize).setEncryptionKeyId(this.encryptionKeyId).setEncryptionScheme(this.encryptionScheme).setEncryptionVersion(this.encryptionVersion).setInitializationVector(this.initializationVector).setIsEncrypted(this.isEncrypted).setIsPrimary(this.isPrimary).setMimeType(this.mimeType);
        }

        @Override
        public void setProxyData(EntityProxyData proxyData) {
        }

        public Updater setContentChecksum(String contentChecksum) {
            this.contentChecksum = contentChecksum;
            return this;
        }

        public Updater setContentFileSize(Long contentFileSize) {
            this.contentFileSize = contentFileSize;
            return this;
        }

        public Updater setEncryptionKeyId(String encryptionKeyId) {
            this.encryptionKeyId = encryptionKeyId;
            return this;
        }

        public Updater setEncryptionScheme(String encryptionScheme) {
            this.encryptionScheme = encryptionScheme;
            return this;
        }

        public Updater setEncryptionVersion(String encryptionVersion) {
            this.encryptionVersion = encryptionVersion;
            return this;
        }

        public Updater setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public Updater setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public Updater setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public Updater setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }
    }

    public static final class Creator
    extends EntityOperationSingleResultBase<AssetFileInfo>
    implements EntityCreateOperation<AssetFileInfo> {
        private final String parentAssetId;
        private final String name;
        private String contentChecksum;
        private Long contentFileSize;
        private String encryptionKeyId;
        private String encryptionScheme;
        private String encryptionVersion;
        private String initializationVector;
        private Boolean isEncrypted;
        private Boolean isPrimary;
        private String mimeType;

        private Creator(String parentAssetId, String name) {
            super(AssetFile.ENTITY_SET, AssetFileInfo.class);
            this.parentAssetId = parentAssetId;
            this.name = name;
        }

        @Override
        public Object getRequestContents() throws ServiceException {
            AssetFileType content = new AssetFileType().setName(this.name).setParentAssetId(this.parentAssetId).setContentChecksum(this.contentChecksum).setContentFileSize(this.contentFileSize).setEncryptionKeyId(this.encryptionKeyId).setEncryptionScheme(this.encryptionScheme).setEncryptionVersion(this.encryptionVersion).setInitializationVector(this.initializationVector).setIsEncrypted(this.isEncrypted).setIsPrimary(this.isPrimary).setMimeType(this.mimeType);
            return content;
        }

        public Creator setContentChecksum(String contentChecksum) {
            this.contentChecksum = contentChecksum;
            return this;
        }

        public Creator setContentFileSize(Long contentFileSize) {
            this.contentFileSize = contentFileSize;
            return this;
        }

        public Creator setEncryptionKeyId(String encryptionKeyId) {
            this.encryptionKeyId = encryptionKeyId;
            return this;
        }

        public Creator setEncryptionScheme(String encryptionScheme) {
            this.encryptionScheme = encryptionScheme;
            return this;
        }

        public Creator setEncryptionVersion(String encryptionVersion) {
            this.encryptionVersion = encryptionVersion;
            return this;
        }

        public Creator setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public Creator setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public Creator setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public Creator setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }
    }
}

