/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.blob.implementation;

import com.microsoft.windowsazure.core.RFC1123DateConverter;
import com.microsoft.windowsazure.core.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.AccessConditionHeader;
import com.microsoft.windowsazure.core.utils.CommaStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.models.BlobProperties;
import com.microsoft.windowsazure.services.blob.models.BlobServiceOptions;
import com.microsoft.windowsazure.services.blob.models.BlockList;
import com.microsoft.windowsazure.services.blob.models.CommitBlobBlocksOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobBlockOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobResult;
import com.microsoft.windowsazure.services.blob.models.CreateContainerOptions;
import com.microsoft.windowsazure.services.blob.models.DeleteBlobOptions;
import com.microsoft.windowsazure.services.blob.models.DeleteContainerOptions;
import com.microsoft.windowsazure.services.blob.models.GetBlobOptions;
import com.microsoft.windowsazure.services.blob.models.GetBlobPropertiesOptions;
import com.microsoft.windowsazure.services.blob.models.GetBlobPropertiesResult;
import com.microsoft.windowsazure.services.blob.models.GetBlobResult;
import com.microsoft.windowsazure.services.blob.models.ListBlobBlocksOptions;
import com.microsoft.windowsazure.services.blob.models.ListBlobBlocksResult;
import com.microsoft.windowsazure.services.blob.models.ListContainersOptions;
import com.microsoft.windowsazure.services.blob.models.ListContainersResult;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.util.Base64;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public abstract class BlobOperationRestProxy
implements BlobContract {
    private static final String API_VERSION = "2011-08-18";
    private final Client channel;
    private final String accountName;
    private final String url;
    private final RFC1123DateConverter dateMapper;
    private final ClientFilter[] filters;

    protected BlobOperationRestProxy(Client channel, String accountName, String url) {
        this(channel, new ClientFilter[0], accountName, url, new RFC1123DateConverter());
    }

    protected BlobOperationRestProxy(Client channel, ClientFilter[] filters, String accountName, String url, RFC1123DateConverter dateMapper) {
        this.channel = channel;
        this.accountName = accountName;
        this.url = url;
        this.filters = filters;
        this.dateMapper = dateMapper;
    }

    public abstract BlobContract withRequestFilterFirst(ServiceRequestFilter var1);

    public abstract BlobContract withRequestFilterLast(ServiceRequestFilter var1);

    public abstract BlobContract withResponseFilterFirst(ServiceResponseFilter var1);

    public abstract BlobContract withResponseFilterLast(ServiceResponseFilter var1);

    protected Client getChannel() {
        return this.channel;
    }

    protected String getAccountName() {
        return this.accountName;
    }

    protected String getUrl() {
        return this.url;
    }

    protected RFC1123DateConverter getDateMapper() {
        return this.dateMapper;
    }

    protected ClientFilter[] getFilters() {
        return this.filters;
    }

    private void throwIfError(ClientResponse r) {
        PipelineHelpers.throwIfError((ClientResponse)r);
    }

    private void throwIfNotSuccess(ClientResponse clientResponse) {
        PipelineHelpers.throwIfNotSuccess((ClientResponse)clientResponse);
    }

    private WebResource addOptionalQueryParam(WebResource webResource, String key, Object value) {
        return PipelineHelpers.addOptionalQueryParam((WebResource)webResource, (String)key, (Object)value);
    }

    private WebResource.Builder addOptionalRangeHeader(WebResource.Builder builder, Long rangeStart, Long rangeEnd) {
        return PipelineHelpers.addOptionalRangeHeader((WebResource.Builder)builder, (Long)rangeStart, (Long)rangeEnd);
    }

    private WebResource addOptionalQueryParam(WebResource webResource, String key, int value, int defaultValue) {
        return PipelineHelpers.addOptionalQueryParam((WebResource)webResource, (String)key, (int)value, (int)defaultValue);
    }

    private WebResource addOptionalContainerIncludeQueryParam(ListContainersOptions options, WebResource webResource) {
        CommaStringBuilder sb = new CommaStringBuilder();
        sb.addValue(options.isIncludeMetadata(), "metadata");
        webResource = this.addOptionalQueryParam(webResource, "include", sb.toString());
        return webResource;
    }

    private WebResource.Builder addOptionalHeader(WebResource.Builder builder, String name, Object value) {
        return PipelineHelpers.addOptionalHeader((WebResource.Builder)builder, (String)name, (Object)value);
    }

    private WebResource.Builder addOptionalMetadataHeader(WebResource.Builder builder, Map<String, String> metadata) {
        return PipelineHelpers.addOptionalMetadataHeader((WebResource.Builder)builder, metadata);
    }

    private WebResource.Builder addOptionalAccessConditionHeader(WebResource.Builder builder, AccessConditionHeader accessCondition) {
        return PipelineHelpers.addOptionalAccessConditionHeader((WebResource.Builder)builder, (AccessConditionHeader)accessCondition);
    }

    private WebResource.Builder addPutBlobHeaders(CreateBlobOptions options, WebResource.Builder builder) {
        builder = this.addOptionalHeader(builder, "Content-Type", options.getContentType());
        if (options.getContentType() == null) {
            builder = (WebResource.Builder)builder.type("application/octet-stream");
        }
        builder = this.addOptionalHeader(builder, "Content-Encoding", options.getContentEncoding());
        builder = this.addOptionalHeader(builder, "Content-Language", options.getContentLanguage());
        builder = this.addOptionalHeader(builder, "Content-MD5", options.getContentMD5());
        builder = this.addOptionalHeader(builder, "Cache-Control", options.getCacheControl());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-type", options.getBlobContentType());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-encoding", options.getBlobContentEncoding());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-language", options.getBlobContentLanguage());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-md5", options.getBlobContentMD5());
        builder = this.addOptionalHeader(builder, "x-ms-blob-cache-control", options.getBlobCacheControl());
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        return builder;
    }

    private WebResource getResource(BlobServiceOptions options) {
        WebResource webResource = this.channel.resource(this.url).path("/");
        webResource = this.addOptionalQueryParam(webResource, "timeout", options.getTimeout());
        for (ClientFilter filter : this.filters) {
            webResource.addFilter(filter);
        }
        return webResource;
    }

    @Override
    public void createContainer(String container) throws ServiceException {
        this.createContainer(container, new CreateContainerOptions());
    }

    @Override
    public void createContainer(String container, CreateContainerOptions options) throws ServiceException {
        if (container == null || container.isEmpty()) {
            throw new IllegalArgumentException("The container cannot be null or empty.");
        }
        WebResource webResource = this.getResource(options).path(container).queryParam("resType", "container");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder = this.addOptionalHeader(builder, "x-ms-blob-public-access", options.getPublicAccess());
        builder.put();
    }

    @Override
    public void deleteContainer(String container) throws ServiceException {
        this.deleteContainer(container, new DeleteContainerOptions());
    }

    @Override
    public void deleteContainer(String container, DeleteContainerOptions options) throws ServiceException {
        if (container == null || container.isEmpty()) {
            throw new IllegalArgumentException("The root container has already been created.");
        }
        WebResource webResource = this.getResource(options).path(container).queryParam("resType", "container");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        builder.delete();
    }

    @Override
    public void deleteBlob(String container, String blob) throws ServiceException {
        this.deleteBlob(container, blob, new DeleteBlobOptions());
    }

    @Override
    public void deleteBlob(String container, String blob, DeleteBlobOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        if (options.getDeleteSnaphotsOnly() != null) {
            builder = this.addOptionalHeader(builder, "x-ms-delete-snapshots", options.getDeleteSnaphotsOnly() != false ? "only" : "include");
        }
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        builder.delete();
    }

    @Override
    public ListContainersResult listContainers() throws ServiceException {
        return this.listContainers(new ListContainersOptions());
    }

    @Override
    public ListContainersResult listContainers(ListContainersOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("/").queryParam("comp", "list");
        webResource = this.addOptionalQueryParam(webResource, "prefix", options.getPrefix());
        webResource = this.addOptionalQueryParam(webResource, "marker", options.getMarker());
        webResource = this.addOptionalQueryParam(webResource, "maxresults", options.getMaxResults(), 0);
        webResource = this.addOptionalContainerIncludeQueryParam(options, webResource);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        return (ListContainersResult)builder.get(ListContainersResult.class);
    }

    @Override
    public CreateBlobResult createBlockBlob(String container, String blob, InputStream contentStream) throws ServiceException {
        return this.createBlockBlob(container, blob, contentStream, new CreateBlobOptions());
    }

    @Override
    public CreateBlobResult createBlockBlob(String container, String blob, InputStream contentStream, CreateBlobOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = (WebResource.Builder)builder.header("x-ms-blob-type", (Object)"BlockBlob");
        builder = this.addPutBlobHeaders(options, builder);
        Object contentObject = contentStream == null ? (Object)new byte[0] : contentStream;
        ClientResponse clientResponse = (ClientResponse)builder.put(ClientResponse.class, contentObject);
        this.throwIfError(clientResponse);
        CreateBlobResult createBlobResult = new CreateBlobResult();
        createBlobResult.setEtag((String)clientResponse.getHeaders().getFirst((Object)"ETag"));
        createBlobResult.setLastModified(this.dateMapper.parse((String)clientResponse.getHeaders().getFirst((Object)"Last-Modified")));
        return createBlobResult;
    }

    @Override
    public void createBlobBlock(String container, String blob, String blockId, InputStream contentStream) throws ServiceException {
        this.createBlobBlock(container, blob, blockId, contentStream, new CreateBlobBlockOptions());
    }

    @Override
    public void createBlobBlock(String container, String blob, String blockId, InputStream contentStream, CreateBlobBlockOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "block");
        try {
            webResource = this.addOptionalQueryParam(webResource, "blockid", new String(Base64.encode((String)blockId), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalHeader(builder, "Content-MD5", options.getContentMD5());
        builder.put((Object)contentStream);
    }

    @Override
    public void commitBlobBlocks(String container, String blob, BlockList blockList) throws ServiceException {
        this.commitBlobBlocks(container, blob, blockList, new CommitBlobBlocksOptions());
    }

    @Override
    public void commitBlobBlocks(String container, String blob, BlockList blockList, CommitBlobBlocksOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "blocklist");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalHeader(builder, "x-ms-blob-cache-control", options.getBlobCacheControl());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-type", options.getBlobContentType());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-encoding", options.getBlobContentEncoding());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-language", options.getBlobContentLanguage());
        builder = this.addOptionalHeader(builder, "x-ms-blob-content-md5", options.getBlobContentMD5());
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        builder.put((Object)blockList);
    }

    @Override
    public GetBlobPropertiesResult getBlobProperties(String container, String blob) throws ServiceException {
        return this.getBlobProperties(container, blob, new GetBlobPropertiesOptions());
    }

    @Override
    public GetBlobPropertiesResult getBlobProperties(String container, String blob, GetBlobPropertiesOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        ClientResponse response = (ClientResponse)builder.method("HEAD", ClientResponse.class);
        this.throwIfNotSuccess(response);
        return this.getBlobPropertiesResultFromResponse(response);
    }

    @Override
    public GetBlobResult getBlob(String container, String blob) throws ServiceException {
        return this.getBlob(container, blob, new GetBlobOptions());
    }

    @Override
    public GetBlobResult getBlob(String container, String blob, GetBlobOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob);
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        builder = this.addOptionalRangeHeader(builder, options.getRangeStart(), options.getRangeEnd());
        builder = this.addOptionalAccessConditionHeader(builder, options.getAccessCondition());
        if (options.isComputeRangeMD5()) {
            builder = this.addOptionalHeader(builder, "x-ms-range-get-content-md5", "true");
        }
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.throwIfNotSuccess(response);
        GetBlobPropertiesResult properties = this.getBlobPropertiesResultFromResponse(response);
        GetBlobResult blobResult = new GetBlobResult();
        blobResult.setProperties(properties.getProperties());
        blobResult.setMetadata(properties.getMetadata());
        blobResult.setContentStream(response.getEntityInputStream());
        return blobResult;
    }

    private GetBlobPropertiesResult getBlobPropertiesResultFromResponse(ClientResponse response) {
        BlobProperties properties = new BlobProperties();
        properties.setLastModified(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"Last-Modified")));
        properties.setBlobType((String)response.getHeaders().getFirst((Object)"x-ms-blob-type"));
        properties.setLeaseStatus((String)response.getHeaders().getFirst((Object)"x-ms-lease-status"));
        properties.setContentLength(Long.parseLong((String)response.getHeaders().getFirst((Object)"Content-Length")));
        properties.setContentType((String)response.getHeaders().getFirst((Object)"Content-Type"));
        properties.setContentMD5((String)response.getHeaders().getFirst((Object)"Content-MD5"));
        properties.setContentEncoding((String)response.getHeaders().getFirst((Object)"Content-Encoding"));
        properties.setContentLanguage((String)response.getHeaders().getFirst((Object)"Content-Language"));
        properties.setCacheControl((String)response.getHeaders().getFirst((Object)"Cache-Control"));
        properties.setEtag((String)response.getHeaders().getFirst((Object)"Etag"));
        if (response.getHeaders().containsKey((Object)"x-ms-blob-sequence-number")) {
            properties.setSequenceNumber(Long.parseLong((String)response.getHeaders().getFirst((Object)"x-ms-blob-sequence-number")));
        }
        HashMap<String, String> metadata = this.getMetadataFromHeaders(response);
        GetBlobPropertiesResult result = new GetBlobPropertiesResult();
        result.setMetadata(metadata);
        result.setProperties(properties);
        return result;
    }

    @Override
    public ListBlobBlocksResult listBlobBlocks(String container, String blob) throws ServiceException {
        return this.listBlobBlocks(container, blob, new ListBlobBlocksOptions());
    }

    @Override
    public ListBlobBlocksResult listBlobBlocks(String container, String blob, ListBlobBlocksOptions options) throws ServiceException {
        String path = this.createPathFromContainer(container);
        WebResource webResource = this.getResource(options).path(path).path(blob).queryParam("comp", "blocklist");
        webResource = this.addOptionalQueryParam(webResource, "snapshot", options.getSnapshot());
        if (options.isCommittedList() && options.isUncommittedList()) {
            webResource = this.addOptionalQueryParam(webResource, "blocklisttype", "all");
        } else if (options.isCommittedList()) {
            webResource = this.addOptionalQueryParam(webResource, "blocklisttype", "committed");
        } else if (options.isUncommittedList()) {
            webResource = this.addOptionalQueryParam(webResource, "blocklisttype", "uncommitted");
        }
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalHeader(builder, "x-ms-lease-id", options.getLeaseId());
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.throwIfError(response);
        ListBlobBlocksResult result = (ListBlobBlocksResult)response.getEntity(ListBlobBlocksResult.class);
        result.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        result.setContentType((String)response.getHeaders().getFirst((Object)"Content-Type"));
        String blobContentLength = (String)response.getHeaders().getFirst((Object)"x-ms-blob-content-length");
        if (blobContentLength != null) {
            result.setContentLength(Long.parseLong(blobContentLength));
        } else {
            result.setContentLength(0L);
        }
        String lastModified = (String)response.getHeaders().getFirst((Object)"Last-Modified");
        if (lastModified != null) {
            result.setLastModified(this.dateMapper.parse(lastModified));
        }
        return result;
    }

    private HashMap<String, String> getMetadataFromHeaders(ClientResponse response) {
        return PipelineHelpers.getMetadataFromHeaders((ClientResponse)response);
    }

    private String createPathFromContainer(String containerName) {
        String path = containerName == null || containerName.isEmpty() ? "$root" : containerName;
        return path;
    }
}

