/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.dao;

import com.clustercontrol.cloud.commons.CloudPropertyConstants;
import com.clustercontrol.cloud.persistence.AbstractProcessor;
import com.clustercontrol.cloud.persistence.ProcessedBy;
import com.clustercontrol.cloud.util.CryptionUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@ProcessedBy(value=CryptionProcessor.class)
public @interface Cryption {
    public String value();

    public static class CryptionProcessor
    extends AbstractProcessor<Cryption> {
        public void preUpdate(Object entity) throws Exception {
            this.crypt(entity);
        }

        public void postUpdate(Object entity) throws Exception {
            this.decrypt(entity);
        }

        public void prePersist(Object entity) throws Exception {
            this.crypt(entity);
        }

        public void postPersist(Object entity) throws Exception {
            this.decrypt(entity);
        }

        public void postLoad(Object entity) throws Exception {
            this.decrypt(entity);
        }

        private void crypt(Object entity) throws Exception {
            String word = (String)this.getMethod.invoke(entity, new Object[0]);
            Method destSetMethod = entity.getClass().getDeclaredMethod(CryptionProcessor.getSetMethodName(((Cryption)this.annotation).value()), String.class);
            destSetMethod.invoke(entity, word != null ? CryptionUtil.crypt((String)word, (String)CloudPropertyConstants.password_crypt_key.value()) : null);
        }

        private void decrypt(Object entity) throws Exception {
            Method getGetMethodName = entity.getClass().getDeclaredMethod(CryptionProcessor.getGetMethodName(((Cryption)this.annotation).value()), new Class[0]);
            String word = (String)getGetMethodName.invoke(entity, new Object[0]);
            this.setMethod.invoke(entity, word != null ? CryptionUtil.decrypt((String)word, (String)CloudPropertyConstants.password_crypt_key.value()) : null);
        }

        private static String getSetMethodName(String propName) {
            return "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        }

        private static String getGetMethodName(String propName) {
            return "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        }
    }
}

