/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl;
import com.microsoft.windowsazure.management.compute.VirtualMachineVMImageOperations;
import com.microsoft.windowsazure.management.compute.models.VirtualHardDiskHostCaching;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineVMImageListResponse;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class VirtualMachineVMImageOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineVMImageOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineVMImageOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<OperationResponse> beginDeletingAsync(final String vmImageName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.beginDeleting(vmImageName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse beginDeleting(String vmImageName, boolean deleteFromStorage) throws IOException, ServiceException {
        if (vmImageName == null) {
            throw new NullPointerException("vmImageName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vmImageName", vmImageName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/vmimages/" + vmImageName.trim() + "?";
        if (deleteFromStorage) {
            url = url + "comp=" + "media";
        }
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<OperationStatusResponse> deleteAsync(final String vmImageName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>(){

            @Override
            public OperationStatusResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.delete(vmImageName, deleteFromStorage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStatusResponse delete(String vmImageName, boolean deleteFromStorage) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("vmImageName", vmImageName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            OperationResponse response = client2.getVirtualMachineVMImagesOperations().beginDeletingAsync(vmImageName, deleteFromStorage).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            while (!(result.getStatus() != OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error((String)invocationId, (Exception)ex);
                    }
                    throw ex;
                }
                ServiceException ex = new ServiceException("");
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationStatusResponse operationStatusResponse = result;
            return operationStatusResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<VirtualMachineVMImageListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineVMImageListResponse>(){

            @Override
            public VirtualMachineVMImageListResponse call() throws Exception {
                return VirtualMachineVMImageOperationsImpl.this.list();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineVMImageListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap tracingParameters = new HashMap();
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        String url = "/" + this.getClient().getCredentials().getSubscriptionId().trim() + "/services/vmimages";
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineVMImageListResponse result = null;
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new VirtualMachineVMImageListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse((InputStream)new BOMInputStream(responseContent));
            Element vMImagesSequenceElement = XmlUtility.getElementByTagNameNS((Node)responseDoc, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImages");
            if (vMImagesSequenceElement != null) {
                for (int i1 = 0; i1 < XmlUtility.getElementsByTagNameNS((Node)vMImagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImage").size(); ++i1) {
                    Element createdTimeElement;
                    Element affinityGroupElement;
                    Element roleNameElement;
                    Element deploymentNameElement;
                    Element serviceNameElement;
                    Element dataDiskConfigurationsSequenceElement;
                    Element oSDiskConfigurationElement;
                    Element categoryElement;
                    Element labelElement;
                    Element vMImagesElement = (Element)XmlUtility.getElementsByTagNameNS((Node)vMImagesSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"VMImage").get(i1);
                    VirtualMachineVMImageListResponse.VirtualMachineVMImage vMImageInstance = new VirtualMachineVMImageListResponse.VirtualMachineVMImage();
                    result.getVMImages().add(vMImageInstance);
                    Element nameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                    if (nameElement != null) {
                        String nameInstance = nameElement.getTextContent();
                        vMImageInstance.setName(nameInstance);
                    }
                    if ((labelElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Label")) != null) {
                        String labelInstance = labelElement.getTextContent();
                        vMImageInstance.setLabel(labelInstance);
                    }
                    if ((categoryElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Category")) != null) {
                        String categoryInstance = categoryElement.getTextContent();
                        vMImageInstance.setCategory(categoryInstance);
                    }
                    if ((oSDiskConfigurationElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSDiskConfiguration")) != null) {
                        Element logicalDiskSizeInGBElement;
                        Element mediaLinkElement;
                        Element osElement;
                        Element oSStateElement;
                        Element hostCachingElement;
                        VirtualMachineVMImageListResponse.OSDiskConfiguration oSDiskConfigurationInstance = new VirtualMachineVMImageListResponse.OSDiskConfiguration();
                        vMImageInstance.setOSDiskConfiguration(oSDiskConfigurationInstance);
                        Element nameElement2 = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                        if (nameElement2 != null) {
                            String nameInstance2 = nameElement2.getTextContent();
                            oSDiskConfigurationInstance.setName(nameInstance2);
                        }
                        if ((hostCachingElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching")) != null && !(hostCachingElement.getTextContent() == null || hostCachingElement.getTextContent().isEmpty())) {
                            VirtualHardDiskHostCaching hostCachingInstance = VirtualHardDiskHostCaching.valueOf(hostCachingElement.getTextContent());
                            oSDiskConfigurationInstance.setHostCaching(hostCachingInstance);
                        }
                        if ((oSStateElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OSState")) != null) {
                            String oSStateInstance = oSStateElement.getTextContent();
                            oSDiskConfigurationInstance.setOSState(oSStateInstance);
                        }
                        if ((osElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"OS")) != null) {
                            String osInstance = osElement.getTextContent();
                            oSDiskConfigurationInstance.setOperatingSystem(osInstance);
                        }
                        if ((mediaLinkElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                            URI mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                            oSDiskConfigurationInstance.setMediaLink(mediaLinkInstance);
                        }
                        if ((logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS((Node)oSDiskConfigurationElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) != null) {
                            int logicalDiskSizeInGBInstance = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement.getTextContent());
                            oSDiskConfigurationInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                        }
                    }
                    if ((dataDiskConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfigurations")) != null) {
                        for (int i2 = 0; i2 < XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").size(); ++i2) {
                            Element logicalDiskSizeInGBElement2;
                            Element mediaLinkElement2;
                            Element lunElement;
                            Element hostCachingElement2;
                            Element dataDiskConfigurationsElement = (Element)XmlUtility.getElementsByTagNameNS((Node)dataDiskConfigurationsSequenceElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DataDiskConfiguration").get(i2);
                            VirtualMachineVMImageListResponse.DataDiskConfiguration dataDiskConfigurationInstance = new VirtualMachineVMImageListResponse.DataDiskConfiguration();
                            vMImageInstance.getDataDiskConfigurations().add(dataDiskConfigurationInstance);
                            Element nameElement3 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Name");
                            if (nameElement3 != null) {
                                String nameInstance3 = nameElement3.getTextContent();
                                dataDiskConfigurationInstance.setName(nameInstance3);
                            }
                            if ((hostCachingElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"HostCaching")) != null && !(hostCachingElement2.getTextContent() == null || hostCachingElement2.getTextContent().isEmpty())) {
                                VirtualHardDiskHostCaching hostCachingInstance2 = VirtualHardDiskHostCaching.valueOf(hostCachingElement2.getTextContent());
                                dataDiskConfigurationInstance.setHostCaching(hostCachingInstance2);
                            }
                            if ((lunElement = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"Lun")) != null && !(lunElement.getTextContent() == null || lunElement.getTextContent().isEmpty())) {
                                int lunInstance = DatatypeConverter.parseInt((String)lunElement.getTextContent());
                                dataDiskConfigurationInstance.setLogicalUnitNumber(lunInstance);
                            }
                            if ((mediaLinkElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"MediaLink")) != null) {
                                URI mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                                dataDiskConfigurationInstance.setMediaLink(mediaLinkInstance2);
                            }
                            if ((logicalDiskSizeInGBElement2 = XmlUtility.getElementByTagNameNS((Node)dataDiskConfigurationsElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"LogicalDiskSizeInGB")) == null) continue;
                            int logicalDiskSizeInGBInstance2 = DatatypeConverter.parseInt((String)logicalDiskSizeInGBElement2.getTextContent());
                            dataDiskConfigurationInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance2);
                        }
                    }
                    if ((serviceNameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"ServiceName")) != null) {
                        String serviceNameInstance = serviceNameElement.getTextContent();
                        vMImageInstance.setServiceName(serviceNameInstance);
                    }
                    if ((deploymentNameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"DeploymentName")) != null) {
                        String deploymentNameInstance = deploymentNameElement.getTextContent();
                        vMImageInstance.setDeploymentName(deploymentNameInstance);
                    }
                    if ((roleNameElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"RoleName")) != null) {
                        String roleNameInstance = roleNameElement.getTextContent();
                        vMImageInstance.setRoleName(roleNameInstance);
                    }
                    if ((affinityGroupElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"AffinityGroup")) != null) {
                        String affinityGroupInstance = affinityGroupElement.getTextContent();
                        vMImageInstance.setAffinityGroup(affinityGroupInstance);
                    }
                    if ((createdTimeElement = XmlUtility.getElementByTagNameNS((Node)vMImagesElement, (String)"http://schemas.microsoft.com/windowsazure", (String)"CreatedTime")) == null || createdTimeElement.getTextContent() == null || createdTimeElement.getTextContent().isEmpty()) continue;
                    Calendar createdTimeInstance = DatatypeConverter.parseDateTime((String)createdTimeElement.getTextContent());
                    vMImageInstance.setCreatedTime(createdTimeInstance);
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineVMImageListResponse virtualMachineVMImageListResponse = result;
            return virtualMachineVMImageListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

