/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FlatteningIterator
implements Iterator {
    private final Deque<Iterator<?>> iterators = new ArrayDeque();
    private Object next;
    private boolean nextBlank = true;

    public void push(Iterator<?> iterator) {
        this.iterators.addFirst(iterator);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void moveToNext() {
        if (this.nextBlank && !this.iterators.isEmpty()) {
            if (!this.iterators.peek().hasNext()) {
                this.iterators.removeFirst();
                this.moveToNext();
            } else {
                Object next = this.iterators.peekFirst().next();
                if (next instanceof Iterator) {
                    this.push((Iterator)next);
                    this.moveToNext();
                } else {
                    this.next = next;
                    this.nextBlank = false;
                }
            }
        }
    }

    public Object next() {
        this.moveToNext();
        if (this.nextBlank) {
            throw new NoSuchElementException();
        }
        Object next = this.next;
        this.next = null;
        this.nextBlank = true;
        return next;
    }

    @Override
    public boolean hasNext() {
        this.moveToNext();
        return !this.nextBlank;
    }
}

