/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.util.Messages;


public class UnregistNodeAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.UnregistNodeAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgDeRegistNodeConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.node", "word.deregist"});
	private String msgDeRegistNodeResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.node", "word.deregist"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		if (
			MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgDeRegistNodeConfirm + "\n" + instance.getInstanceId())
			){
			instance.getCloudInstanceManager().unregistNode(instance.getInstanceId());
			
			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
				null,
				Messages.getString("successful"),
				msgDeRegistNodeResult);
		}
		else {
			return;
		}
	}

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		return ICloudInstance.RegistStateType.deleted.name().equals(instance.getRegistState());
	}
}