/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CloudUser;
import com.clustercontrol.cloud.presenter.ModifyCloudUserRequest;
import com.clustercontrol.cloud.ui.dialogs.CreateCloudUserDialog;
import com.clustercontrol.util.Messages;


public class EditCloudUserAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditCloudUserAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgEditCloudUserConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.cloud_user", "word.modify"});
	private String msgEditCloudUserResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.cloud_user", "word.modify"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		
		CreateCloudUserDialog dialog = new CreateCloudUserDialog(this.viewPart.getSite().getShell());

		IStructuredSelection selection = (IStructuredSelection) this.viewPart.getSite().getSelectionProvider().getSelection();
		final CloudUser cloudUser = (CloudUser)selection.getFirstElement();
		
		dialog.setBehavior(new CreateCloudUserDialog.DialogBehavior(){
			
			
			@Override
			public void setupCloudUserId(Text cloudUserId){
				if(cloudUser != null && cloudUser.getCloudUserId() != null){
					cloudUserId.setText(cloudUser.getCloudUserId());
				}
				cloudUserId.setEditable(false);
			}
			@Override
			public void setupCloudUserName(Text cloudUserName){
				if(cloudUser != null && cloudUser.getCloudUserName() != null){
					cloudUserName.setText(cloudUser.getCloudUserName());
				}
			}
			@Override
			public void setupDescription(Text description) {
				if(cloudUser != null && cloudUser.getDescription() != null){
					description.setText(cloudUser.getDescription());
				}
			}
			@Override
			public void setupAccessKey(Text accessKey) {
				if(cloudUser != null && cloudUser.getAccessKey() != null){
					accessKey.setText(cloudUser.getAccessKey());
				}
			}
			@Override
			public void setupSecretKey(Text secretKey) {
				if(cloudUser != null && cloudUser.getSecretKey() != null){
					secretKey.setText(cloudUser.getSecretKey());
				}
			}
			@Override
			public void setupAssignRoleId(Combo assignRoleId) {
//				super.setupAssignRoleId(assignRoleId);
				assignRoleId.add(cloudUser.getRoleId());
//				if(cloudUser.getRoleId() != null &&
//						assignRoleId.indexOf(cloudUser.getRoleId()) != -1){
					assignRoleId.select(assignRoleId.indexOf(cloudUser.getRoleId()));
//				}
				assignRoleId.setEnabled(false);
			}
			@Override
			public void setupAccountResourceId(Combo accountResourceId) {
				super.setupAccountResourceId(accountResourceId);
				if(cloudUser.getAccountResourceId() != null &&
						accountResourceId.indexOf(cloudUser.getAccountResourceId()) != -1){
					accountResourceId.select(accountResourceId.indexOf(cloudUser.getAccountResourceId()));
				}
				accountResourceId.setEnabled(false);
			}
		});
		
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgEditCloudUserConfirm)) {

				CreateCloudUserDialog.DialogOutput output = dialog.getOutput();
				
				ModifyCloudUserRequest request = new ModifyCloudUserRequest(); 
				ControlUtil.importObject(request, output);
				cloudUser.modifyCloudUser(request);
				
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgEditCloudUserResult);
			}
			else {
				return;
			}
		}
	}
}