/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.presenter.IFacility;
import com.clustercontrol.util.LoginManager;


/**
 */
public class TemplatesView extends AbstractCloudViewPart implements ISelectionListener, IAROrientedView {
	public static final String Id = "com.clustercontrol.cloud.ui.views.TemplatesView";
	private static MessageManager bundle_messages = MessageManager.getInstance("messages");
	
	private Table table;
	private TableViewer tableViewer;
	private Label lblHeader;
	private Label lblFooter;
	private ICloudTemplateManager cloudTemplateManager;
	private List<ICloudTemplate> cloudTemplates;
	private IAccountResource accountResource;
	private String headerTitle = bundle_messages.getString("word.account_resource_id") + bundle_messages.getString("caption.title_separator");
	private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");
	private IRegion region;
	
	private CollectionObserver2<ICloudTemplate> elementObserver = new CollectionObserver2<ICloudTemplate>() {
		@Override
		public void elementAdded(ElementAddedEvent<ICloudTemplate> event) {
			event.getAddedElement().addPropertyObserver2(IElement.allProperty, propertyObserver);

			cloudTemplates.add(event.getAddedElement());
//			tableViewer.setInput(cloudTemplates);
			internalSetInput();

			lblFooter.setText(footerTitle + cloudTemplates.size());

			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<ICloudTemplate> event) {
			event.getRemovedElement().removePropertyObserver2(IElement.allProperty, propertyObserver);

			cloudTemplates.remove(event.getRemovedElement());
//			tableViewer.setInput(cloudTemplates);
			internalSetInput();
			
			lblFooter.setText(footerTitle + cloudTemplates.size());

			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	private AllPropertyObserver propertyObserver = new AllPropertyObserver() {
		@Override
		public void propertyChanged(ValueChangedEvent event) {
			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementRemoved(ElementRemovedEvent event) {
			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementAdded(ElementAddedEvent event) {
			TemplatesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = TemplatesView.this.tableViewer.getSelection();
					TemplatesView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	public TemplatesView() {
 		super();
		LoginManager.login();  // ログインしていない場合は、ビュー表示前に必ずログインダイアログを出すようにする
	}
	
 	@Override
	protected void internalCreatePartControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		for(final ViewColumn column: ViewColumn.values()){
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tcl_composite_1.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}

		this.getSite().setSelectionProvider(tableViewer);
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		lblFooter = new Label(composite, SWT.NONE);
		lblFooter.setAlignment(SWT.RIGHT);
		lblFooter.setSize(lblFooter.getSize().x, 80);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblFooter.setLayoutData(gridData);
		
		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		getSite().getPage().addSelectionListener(this);
		
		try {
			update();
		}
		catch (Throwable e) {
			lblFooter.setText(footerTitle + 0);
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
		}

		getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(
				new Runnable() {
					@Override
					public void run() {
						IViewPart view = getSite().getPage().findView(ScopeView.Id);
						view.getSite().getPage().activate(view);
						view.getSite().getSelectionProvider().setSelection(view.getSite().getSelectionProvider().getSelection());
						getSite().getPage().activate(TemplatesView.this);
					}
				});
	}

	private List<ICloudTemplate> getCloudTemplates() {
		if (cloudTemplates == null) {
			try {
				cloudTemplates = new ArrayList<ICloudTemplate>();
				if(cloudTemplateManager != null){
					cloudTemplateManager.addPropertyObserver2(ICloudTemplateManager.p2.cloudTemplates, elementObserver);
					for (ICloudTemplate cloudTemplate: cloudTemplateManager.getCloudTemplates()) {
						cloudTemplate.addPropertyObserver2(IElement.allProperty, propertyObserver);
					}
					
					cloudTemplates.addAll(Arrays.asList(cloudTemplateManager.getCloudTemplates()));
				}
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(TemplatesView.class);
				logger.warn("fail to get cloudTemplates", e);

				cloudTemplates = new ArrayList<ICloudTemplate>();
			}
		}
		
		return cloudTemplates;
	}
 	
	private void changeInput(boolean update) {
		if (cloudTemplates != null) {
			for (ICloudTemplate cloudTemplate: cloudTemplates) {
				cloudTemplate.removePropertyObserver2(IElement.allProperty, propertyObserver);
			}
			cloudTemplates = null;
		}

		if (cloudTemplateManager != null) {
			cloudTemplateManager.removePropertyObserver2(ICloudTemplateManager.p2.cloudTemplates, elementObserver);
			if (update) cloudTemplateManager.update();
		}

		List<ICloudTemplate> cloudTemplates = getCloudTemplates();
//		tableViewer.setInput(cloudTemplates);
		internalSetInput();
		lblFooter.setText(footerTitle + cloudTemplates.size());
	}
	
	public void update() {
		changeInput(true);
	}
	
	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (part instanceof ScopeView && selection instanceof IStructuredSelection) {
			if (cloudTemplateManager != null) {
				cloudTemplateManager.removePropertyObserver2(ICloudTemplateManager.p2.cloudTemplates, elementObserver);
			}
			cloudTemplateManager = null;
			if(cloudTemplates != null){
				cloudTemplates.clear();
			}
			if(((IStructuredSelection)selection).size() != 1){
				lblHeader.setText(headerTitle);
			} else {
				StringBuffer sb = new StringBuffer();
				IFacility facility = (IFacility)((IStructuredSelection)selection).getFirstElement();
				if(facility.getAccountResourceId() != null){
					IAccountResource accountResource = Activator.getDefault().getCloudResourceManager().getAccountResourceManager().getAccountResource(facility.getAccountResourceId());
					setAccountResource(accountResource);
					if(facility.getRegion() != null){
						for(IRegion tmpRegion: accountResource.getRegions()){
							if(tmpRegion.getRegion().equals(facility.getRegion())){
								region = tmpRegion;
								break;
							}
						}
					} else {
						region = null;
					}
					this.cloudTemplateManager = accountResource.getCloudTemplateManager();
					this.cloudTemplateManager.addPropertyObserver2(ICloudTemplateManager.p2.cloudTemplates, elementObserver);
					sb.append(accountResource.getAccountResourceId());
				} else {
					setAccountResource(null);
					region = null;
				}
				lblHeader.setText(headerTitle + sb.toString());
			}
			firePropertyChange(IAROrientedView.Prop_AccountResource);
			changeInput(false);
		}
	}
	
	public IAccountResource getAccountResource() {
		return accountResource;
	}

	private void setAccountResource(IAccountResource accountResource) {
		this.accountResource = accountResource;
	}

	private enum ViewColumn{
		template_id(
			bundle_messages.getString("word.template_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudTemplate)element).getTemplateId();
				}
			}
		),
		template_name(
			bundle_messages.getString("word.template_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudTemplate)element).getTemplateName();
				}
			}
		),
		template_job_for_create(
			bundle_messages.getString("word.template_job_for_create"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudTemplate)element).getLaunchJobId();
				}
			}
		),
		image_id(
			bundle_messages.getString("word.image_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudTemplate)element).getImageId();
				}
			}
		),
		region(
			bundle_messages.getString("word.region"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudTemplate)element).getRegion();
				}
			}
		),
//		zone(
//			bundle_messages.getString("word.zone"),
//			new ColumnPixelData(100, true, true),
//			new ColumnLabelProvider(){
//				@Override
//				public String getText(Object element) {
//					return ((ICloudTemplate)element).getZone();
//				}
//			}
//		),
		reg_user(
			bundle_messages.getString("word.reg_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudTemplate)element).getRegUser();
				}
			}
		),
		reg_date(
			bundle_messages.getString("word.reg_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudTemplate)element).getRegDate() != null){
						return format.format(((ICloudTemplate)element).getRegDate());
					}
					return "";
				}
			}
		),
		update_user(
			bundle_messages.getString("word.update_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((ICloudTemplate)element).getUpdateUser();
				}
			}
		),
		update_date(
			bundle_messages.getString("word.update_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((ICloudTemplate)element).getUpdateDate() != null){
						return format.format(((ICloudTemplate)element).getUpdateDate());
					}
					return "";
				}
			}
		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}

	@Override
	public void dispose() {
		getSite().getPage().removeSelectionListener(this);
		getSite().setSelectionProvider(null);
		super.dispose();
	}

	@Override
	public IAccountResource getCurrentAccountResource() {
		return getAccountResource();
	}

	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
	
	public IRegion getActiveRegion(){
		return region;
	}
	
	private void internalSetInput(){
		if(tableViewer != null && cloudTemplates != null){
			if(region != null){
				List<ICloudTemplate> tmpList = new ArrayList<ICloudTemplate>();
				for(ICloudTemplate template: cloudTemplates){
					if(template.getRegion().equals(region.getRegion())){
						tmpList.add(template);
					}
				}
				tableViewer.setInput(tmpList);
			} else {
				tableViewer.setInput(cloudTemplates);
			}
		}
	}
}
