/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractCloudViewPart extends ViewPart {

	@Override
	public void createPartControl(Composite parent) {
		internalCreatePartControl(parent);
		if (isNeedDefaultPopupMenu()) createDefaultContextMenu();
	}

	protected abstract void internalCreatePartControl(Composite parent);

	protected abstract StructuredViewer getViewer();
	
	@Override
	public void setFocus() {
		getViewer().getControl().setFocus();
	}
	
	protected void createDefaultContextMenu() {
		MenuManager menuManager = new MenuManager();
		getSite().registerContextMenu(menuManager, getSite().getSelectionProvider());
		
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(getViewer().getControl());
		getViewer().getControl().setMenu(menu);
	}

	protected void fillContextMenu(IMenuManager manager) {
	}

	protected boolean isNeedDefaultPopupMenu() {
		return true;
	}
}
