/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.ICloudService;
import com.clustercontrol.cloud.presenter.ICloudServiceManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.AvailableRole;

public class CreateAccountResourceDialog extends Dialog {
	
	public interface IDialogBehavior{
		void setupAccountResourceId(Text ccountResourceId);
		void setupAccountResourceName(Text txtAccountResourceName);
		void setupAccountResourceDescription(Text txtAccountResourceDescription);
		void setupCloudServiceId(Combo cmbCloudServiceId);
		void setupCloudUserId(Text txtCloudUserId);
		void setupCloudUserName(Text txtCloudUserName);
		void setupCloudUserDescription(Text txtCloudUserDescription);
//		void setupAccountId(Text txtAccountId);
		void setupAccessKey(Text txtAccessKey);
		void setupSecretKey(Text txtSecretKey);
		void setupAssignRoleId(Combo cmbAssingRoleId);
	}
	
	public static class DialogBehavior implements IDialogBehavior{
		private ICloudServiceManager cloudServiceManager = Activator.getDefault().getCloudResourceManager().getCloudServiceManager();
		@Override
		public void setupAccountResourceId(Text txtAccountResourceId) {}
		@Override
		public void setupAccountResourceName(Text txtAccountResourceName) {}
		@Override
		public void setupAccountResourceDescription(Text txtAccountResourceDescription) {}
		@Override
		public void setupCloudServiceId(Combo cmbCloudServiceId) {
			for(ICloudService cloudService: cloudServiceManager.getCloudServices()){
				cmbCloudServiceId.add(cloudService.getCloudServiceName());
				cmbCloudServiceId.setData(cloudService.getCloudServiceName(), cloudService.getCloudServiceId());
			}
			if(cmbCloudServiceId.getItemCount() > 0){
				cmbCloudServiceId.select(0);
			}
		}
		@Override
		public void setupCloudUserId(Text txtCloudUserId) {}
		@Override
		public void setupCloudUserName(Text txtCloudUserName) {}
		@Override
		public void setupCloudUserDescription(Text txtCloudUserDescription) {}
		@Override
		public void setupAccessKey(Text txtAccessKey) {}
		@Override
		public void setupSecretKey(Text txtSecretKey) {}
		@Override
		public void setupAssignRoleId(Combo cmbAssignRoleId) {
			for(AvailableRole role: AccountControlUtil.getAssignableRoles()){
				String roleLabel = role.getRoleName() + "(" + role.getRoleId() + ")"; 
				cmbAssignRoleId.add(roleLabel);
				cmbAssignRoleId.setData(roleLabel, role.getRoleId());
			}
			if(cmbAssignRoleId.getItemCount() > 0){
				cmbAssignRoleId.select(0);
			}
		}
//		@Override
//		public void setupAccountId(Text txtAccountId) {}
	}
	
	public static class DialogOutput{
		private String accountResourceId;
		private String accountResourceName;
		private String accountResourceDescription;
		private String cloudServiceId;
		private String cloudUserId;
		private String cloudUserName;
		private String cloudUserDescription;
//		private String accountId;
		private String accessKey;
		private String secretKey;
		private String roleId;
		public String getAccountResourceId() {
			return accountResourceId;
		}
		public void setAccountResourceId(String accountResourceId) {
			this.accountResourceId = accountResourceId;
		}
		public String getAccountResourceName() {
			return accountResourceName;
		}
		public void setAccountResourceName(String accountResourceName) {
			this.accountResourceName = accountResourceName;
		}
		public String getAccountResourceDescription() {
			return accountResourceDescription;
		}
		public void setAccountResourceDescription(String accountResourceDescription) {
			this.accountResourceDescription = accountResourceDescription;
		}
		public String getCloudServiceId() {
			return cloudServiceId;
		}
		public void setCloudServiceId(String cloudServiceId) {
			this.cloudServiceId = cloudServiceId;
		}
		public String getCloudUserId() {
			return cloudUserId;
		}
		public void setCloudUserId(String cloudUserId) {
			this.cloudUserId = cloudUserId;
		}
		public String getCloudUserName() {
			return cloudUserName;
		}
		public void setCloudUserName(String cloudUserName) {
			this.cloudUserName = cloudUserName;
		}
		public String getCloudUserDescription() {
			return cloudUserDescription;
		}
		public void setCloudUserDescription(String cloudUserDescription) {
			this.cloudUserDescription = cloudUserDescription;
		}
//		public String getAccountId() {
//			return accountId;
//		}
//		public void setAccountId(String accountId) {
//			this.accountId = accountId;
//		}
		public String getAccessKey() {
			return accessKey;
		}
		public void setAccessKey(String accessKey) {
			this.accessKey = accessKey;
		}
		public String getSecretKey() {
			return secretKey;
		}
		public void setSecretKey(String secretKey) {
			this.secretKey = secretKey;
		}
		public String getRoleId() {
			return roleId;
		}
		public void setRoleId(String roleId) {
			this.roleId = roleId;
		}
	}
	
	private DialogOutput output = new DialogOutput();
	
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

//	private Shell shell;
	
	private String strSeparator = bundle_messages.getString("caption.title_separator");
	private String strAccountResourceId = bundle_messages.getString("word.account_resource_id");
	private String strAccountResourceName = bundle_messages.getString("word.account_resource_name");
	private String strAccountResourceDescription = bundle_messages.getString("word.account_resource_description");
	private String strCloudServiceId = bundle_messages.getString("word.cloud_service_id");
	private String strCloudUserId = bundle_messages.getString("word.cloud_user_id");
	private String strCloudUserName = bundle_messages.getString("word.cloud_user_name");
	private String strCloudUserDescription = bundle_messages.getString("word.cloud_user_description");
//	private String strAccountId = bundle_messages.getString("word.account_id");
	private String strAccessKey = bundle_messages.getString("word.access_key");
	private String strSecretKey = bundle_messages.getString("word.secret_key");
	private String strAssignRoleId = bundle_messages.getString("word.assign_role_id");
	private String strAccountResource = bundle_messages.getString("word.account_resource");
	private String strCloudService = bundle_messages.getString("word.cloud_service");
	private String strCloudUser = bundle_messages.getString("word.cloud_user");
//	private String strCreateRole = bundle_messages.getString("word.create");
	
	@RequiredInput("strAccountResourceId")
	private Text txtAccountResourceId;
	@RequiredInput("strAccountResourceName")
	private Text txtAccountResourceName;
	private Text txtAccountResourceDescription;
	@RequiredSelect("strCloudServiceId")
	private Combo cmbCloudServiceId;
	@RequiredInput("strCloudUserId")
	private Text txtCloudUserId;
	@RequiredInput("strCloudUserName")
	private Text txtCloudUserName;
	private Text txtCloudUserDescription;
//	private Text txtAccountId;
	@RequiredInput("strAccessKey")
	private Text txtAccessKey;
	@RequiredInput("strSecretKey")
	private Text txtSecretKey;
	@RequiredSelect("strAssignRoleId")
	private Combo cmbAssignRoleId;
	

	private IDialogBehavior behavior = new DialogBehavior();

	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateAccountResourceDialog(Shell parentShell) {
		super(parentShell);
//		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(1, false);
		gl_container.verticalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.verticalAlignment = SWT.FILL;
		gd_container.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gd_container);
		
		Group grpAccountResource = new Group(container, SWT.NONE);
		GridLayout gl_accountResource = new GridLayout(2, false);
		gl_accountResource.verticalSpacing = 15;
		grpAccountResource.setLayout(gl_accountResource);
		grpAccountResource.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		grpAccountResource.setText(strAccountResource);
		
		Label lblAccountResourceId = new Label(grpAccountResource, SWT.RIGHT);
		lblAccountResourceId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAccountResourceId.setText(strAccountResourceId + strSeparator);

		txtAccountResourceId = new Text(grpAccountResource, SWT.BORDER);
		txtAccountResourceId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label lblAccountResourceName = new Label(grpAccountResource, SWT.RIGHT);
		lblAccountResourceName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAccountResourceName.setText(strAccountResourceName + strSeparator);

		txtAccountResourceName = new Text(grpAccountResource, SWT.BORDER);
		txtAccountResourceName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label lblDescription = new Label(grpAccountResource, SWT.RIGHT);
		lblDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText(strAccountResourceDescription + strSeparator);

		txtAccountResourceDescription = new Text(grpAccountResource, SWT.BORDER);
		txtAccountResourceDescription.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
			
		Group grpCloudService = new Group(container, SWT.NONE);
		GridLayout gl_cloudService = new GridLayout(2, false);
		gl_cloudService.verticalSpacing = 15;
		grpCloudService.setLayout(gl_cloudService);
		grpCloudService.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		grpCloudService.setText(strCloudService);

		Label lblCloudServiceId = new Label(grpCloudService, SWT.RIGHT);
		lblCloudServiceId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblCloudServiceId.setText(strCloudServiceId + strSeparator);

		cmbCloudServiceId = new Combo(grpCloudService, SWT.READ_ONLY);
		GridData gd_cloudServiceId = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_cloudServiceId.widthHint = 100;
		cmbCloudServiceId.setLayoutData(gd_cloudServiceId);

		Group grpCloudUser = new Group(container, SWT.NONE);
		GridLayout gl_cloudUser = new GridLayout(2, false);
		gl_cloudUser.verticalSpacing = 15;
		grpCloudUser.setLayout(gl_cloudUser);
		grpCloudUser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		grpCloudUser.setText(strCloudUser);

		Label lblCloudUserId = new Label(grpCloudUser, SWT.RIGHT);
		lblCloudUserId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblCloudUserId.setText(strCloudUserId + strSeparator);

		txtCloudUserId = new Text(grpCloudUser, SWT.BORDER);
		txtCloudUserId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Label lblCloudUserName = new Label(grpCloudUser, SWT.RIGHT);
		lblCloudUserName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblCloudUserName.setText(strCloudUserName + strSeparator);

		txtCloudUserName = new Text(grpCloudUser, SWT.BORDER);
		txtCloudUserName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label lblCloudUserDescription = new Label(grpCloudUser, SWT.RIGHT);
		lblCloudUserDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblCloudUserDescription.setText(strCloudUserDescription + strSeparator);

		txtCloudUserDescription = new Text(grpCloudUser, SWT.BORDER);
		txtCloudUserDescription.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

//			Label lblAccountId = new Label(grpCloudUser, SWT.RIGHT);
//			lblAccountId.setText(strAccountId + strSeparator);
//	
//			txtAccountId = new Text(grpCloudUser, SWT.BORDER);
//			txtAccountId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label lblAccessKey = new Label(grpCloudUser, SWT.RIGHT);
		lblAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAccessKey.setText(strAccessKey + strSeparator);

		txtAccessKey = new Text(grpCloudUser, SWT.BORDER);
		txtAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		Label lblSecretKey = new Label(grpCloudUser, SWT.RIGHT);
		lblSecretKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 6));
		lblSecretKey.setText(strSecretKey + strSeparator);

		txtSecretKey = new Text(grpCloudUser, SWT.MULTI | SWT.BORDER | SWT.PASSWORD | SWT.V_SCROLL);
		GridData gd_SecretKey = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 6);
		gd_SecretKey.heightHint=0;
		gd_SecretKey.widthHint=0;
		txtSecretKey.setLayoutData(gd_SecretKey);
		
		Label lblOwnerId = new Label(grpCloudUser, SWT.RIGHT);
		lblOwnerId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblOwnerId.setText(strAssignRoleId + strSeparator);

		Composite cmpOwnerId = new Composite(grpCloudUser, SWT.NONE);
//			GridLayout gl_cmpOwnerId = new GridLayout(2, false);
		GridLayout gl_cmpOwnerId = new GridLayout(1, false);
		gl_cmpOwnerId.marginWidth = 0;
		cmpOwnerId.setLayout(gl_cmpOwnerId);
		cmpOwnerId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		cmbAssignRoleId = new Combo(cmpOwnerId, SWT.READ_ONLY);
		GridData gd_ownerId = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_ownerId.widthHint = 100;
		cmbAssignRoleId.setLayoutData(gd_ownerId);
		
//			Button btnCreateOwnerRoll = new Button(cmpOwnerId, SWT.NONE);
//			btnCreateOwnerRoll.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, true, 1, 1));
//			btnCreateOwnerRoll.setText(strCreateRole);
//			btnCreateOwnerRoll.addSelectionListener(new SelectionAdapter(){
//				@Override
//				public void widgetSelected(SelectionEvent e) {
//					// ダイアログを生成
//					RoleDialog dialog = new RoleDialog(CreateAccountResourceDialog.this.shell, null, false);
//
//					if (dialog.open() == IDialogConstants.OK_ID) {
//						cmbAssignRoleId.removeAll();
//
//						//ロール情報取得
//						List<RoleInfo> infoList = null;
//						try {
//							infoList = AccessEndpointWrapper.getRoleInfoList();
//						} catch (InvalidRole_Exception e1) {
//							// 権限なし
//							MessageDialog.openInformation(null, Messages.getString("message"),
//									Messages.getString("message.accesscontrol.16"));
//
//							// 一覧の参照権限がない場合、ユーザ自身の情報を表示する
//							infoList = new ArrayList<RoleInfo>();
//
//						} catch (Exception e1) {
//							// 上記以外の例外
//							System.out.println(e1.getMessage());
//							MessageDialog.openError(
//									null,
//									Messages.getString("failed"),
//									Messages.getString("message.hinemos.failure.unexpected") + ", " + e1.getMessage());
//						}
//						if(infoList != null && !infoList.isEmpty()){
//							for(RoleInfo info: infoList){
//								cmbAssignRoleId.add(info.getId());
//							}
//							if(cmbAssignRoleId.getItemCount() > 0){
//								cmbAssignRoleId.select(0);
//							}
//						}
//					}
//				}
//			});
		
		
		{
			behavior.setupAccountResourceId(txtAccountResourceId);
			behavior.setupAccountResourceName(txtAccountResourceName);
			behavior.setupAccountResourceDescription(txtAccountResourceDescription);
			behavior.setupCloudServiceId(cmbCloudServiceId);
			behavior.setupCloudUserId(txtCloudUserId);
			behavior.setupCloudUserName(txtCloudUserName);
			behavior.setupCloudUserDescription(txtCloudUserDescription);
//			behavior.setupAccountId(txtAccountId);
			behavior.setupAccessKey(txtAccessKey);
			behavior.setupSecretKey(txtSecretKey);
			behavior.setupAssignRoleId(cmbAssignRoleId);
		}
		
		ControlUtil.setRequired(new Control[]{
			txtAccountResourceId,
			txtAccountResourceName,
			txtCloudUserId,
			txtCloudUserName,
			txtAccessKey,
			txtSecretKey
		});

		container.layout();
		Control[] labels = new Control[]{lblAccountResourceId, lblAccountResourceName, lblDescription, lblCloudServiceId, lblCloudUserId, lblCloudUserName, lblCloudUserDescription, lblAccessKey, lblSecretKey, lblOwnerId};
		int maxWidth = 0;
		for (Control l: labels) {
			Point p = l.getSize();
			maxWidth = Math.max(maxWidth, p.x);
		}
		for (Control l: labels) {
			((GridData)l.getLayoutData()).widthHint = maxWidth;
		}
		grpAccountResource.layout(true);
		grpCloudService.layout(true);
		grpCloudUser.layout(true);
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 640);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}
		
		{
			output.setAccountResourceId(txtAccountResourceId.getText());
			output.setAccountResourceName(txtAccountResourceName.getText());
			output.setAccountResourceDescription(txtAccountResourceDescription.getText());
			output.setCloudServiceId((String)cmbCloudServiceId.getData(cmbCloudServiceId.getText()));
			output.setCloudUserId(txtCloudUserId.getText());
			output.setCloudUserName(txtCloudUserName.getText());
			output.setCloudUserDescription(txtCloudUserDescription.getText());
//			output.setAccountId(txtAccountId.getText());
			output.setAccessKey(txtAccessKey.getText());
			output.setSecretKey(txtSecretKey.getText());
			output.setRoleId((String)cmbAssignRoleId.getData(cmbAssignRoleId.getText()));
		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_messages.getString("caption.create_account_resource_dialog"));
	}

	public DialogOutput getOutput() {
		return output;
	}

	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}
}
