/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;



public interface INode extends IFacility {
	// プロパティの Id
	interface p2 {
		static final PropertyId2<ValueObserver2<IScope>> parent = new PropertyId2<ValueObserver2<IScope>>();
		static final PropertyId2<ValueObserver2<NodeType>> nodeType = new PropertyId2<ValueObserver2<NodeType>>();
	}

	
	
	enum NodeType {
		account_resource,
		node{
			public String getAccountResourceId(INode node){
				return node.getAccountScope().getFacilityId().replace("_Scope", "");
			}
			public String getRegion(INode node){
				return node.getRegionScope().getFacilityId().replace(getAccountResourceId(node) + "_", "");
			}
		},
		;
		
		public String getAccountResourceId(INode node){return null;};
		public String getRegion(INode node){return null;};
	}

	NodeType getNodeType();
	
	IScope getParent();
	IScope getAccountScope();
	IScope getRegionScope();
	IScope getZoneScope();
}
