/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import java.lang.reflect.Field;







public abstract class Element implements IElement {
	/**
	 * プロパティ変更通知処理をカプセル化したクラス。
	 */
	protected final PropChangedEventNotifier notifier3 = new PropChangedEventNotifier();

	/**
	 * イベント通知処理をカプセル化したクラス。
	 */
	protected final EventNotifier2 notifier2 = new EventNotifier2();
	
	public Element() {
	}
	
	@Override
	public void update() {
		fireEvent(new UpdateEvent(this));
	}
	@Override
	public <L extends EventListener> void addEventListener(Type<L> type, L listener) {
		notifier2.addEventListeners(type, listener);
	}
	@Override
	public <L extends EventListener> void removeEventListener(Type<L> type, L listener) {
		notifier2.removeEventListeners(type, listener);
	}

	/**
	 * 指定したイベントの通知を実施する。
	 * 
	 * @param <S>
	 * @param <L>
	 * @param event
	 */
	protected <S, L extends EventListener> void fireEvent(Event<S, L> event) {
		notifier2.fireEvent(event);
	}

	@Override
	public <P, O extends PropertyObserver2<P>> void addPropertyObserver2(PropertyId2<O> pid, O observer) {
		notifier3.addPropertyObserver(pid, observer);
	}
	@Override
	public <P, O extends PropertyObserver2<P>> void removePropertyObserver2(PropertyId2<O> pid, O observer) {
		notifier3.removePropertyObserver(pid, observer);
	}
	
	/**
	 * シンプルプロパティの変更通知を実施する。
	 * 
	 * @param <P>
	 * @param source
	 * @param pid
	 * @param newValue
	 * @param oldValue
	 */
	protected <P> void firePropertyChanged2(Object source, PropertyId2<ValueObserver2<P>> pid, P newValue, P oldValue) {
		notifier3.fireValueChanged(this, pid, newValue, oldValue);
	}
	
	/**
	 * コレクションプロパティの要素追加通知を実施する。
	 * 
	 * @param <P>
	 * @param source
	 * @param pid
	 * @param addedValue
	 */
	protected <P> void fireElementAdded(PropertyId2<CollectionObserver2<P>> pid, P addedValue) {
		notifier3.fireElementAdded(this, pid, addedValue);
	}
	
	/**
	 * コレクションプロパティの要素削除通知を実施する。
	 * 
	 * @param <P>
	 * @param source
	 * @param pid
	 * @param removedValue
	 */
	public <P> void fireElementRemoved(PropertyId2<CollectionObserver2<P>> pid, P removedValue) {
		notifier3.fireElementRemoved(this, pid, removedValue);
	}
	
	protected <T> void internalSet(String propName, PropertyId2<ValueObserver2<T>> pid, T newValue) {
		Field f = null;
		for (Class<?> clazz = this.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
			try {
				f = clazz.getDeclaredField(propName);
				break;
			}
			catch (NoSuchFieldException e) {
				
			}
			catch (Exception e) {
				throw new CloudModelException(e);
			}
		}
		if (f == null) {
			throw new IllegalStateException("not foung field." + "field name is " + propName + ".");
		}
		
		boolean accessible = true;
		try {
			accessible = f.isAccessible();
			if (!accessible) {
				f.setAccessible(true);
			}

			@SuppressWarnings("unchecked")
			T prop = (T)f.get(this);

			if (prop == null) {
				if (newValue == null) {
					return;
				}
			}
			else {
				if (prop.equals(newValue)) {
					return;
				}
			}

			T old = prop;
			f.set(this, newValue);
			
			// 更新分を通知。
			firePropertyChanged2(this, pid, old, newValue);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
		finally {
			if (!accessible) {
				f.setAccessible(false);
			}
		}
	}
}
