/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.presenter.AccountResource.Region;
import com.clustercontrol.ws.cloud.CloudEndpoint;

public class CloudComputeService extends Element implements ICloudComputeService {
	private AccountResource.Region region;
	
	private CloudInstanceManager instanceManager;
	private CloudStorageManager storageManager;
	private CloudInstanceBackupManager instanceBackupManager;
	private CloudStorageBackupManager storageBackupManager;

	public CloudComputeService(AccountResource.Region region) {
		this.region = region;
	}

	@Override
	public Region getRegion() {
		return region;
	}

	public CloudInstanceManager getInstanceManager() {
		if(instanceManager == null){
			instanceManager = new CloudInstanceManager(this);
		}
		return instanceManager;
	}

	@Override
	public ICloudStorageManager getStorageManager() {
		if(storageManager == null){
			storageManager = new CloudStorageManager(this);
		}
		return storageManager;
	}

	@Override
	public CloudInstanceBackupManager getInstanceBackupManager() {
		if(instanceBackupManager == null){
			instanceBackupManager = new CloudInstanceBackupManager(this);
		}
		return instanceBackupManager;
	}

	@Override
	public CloudStorageBackupManager getStorageBackupManager() {
		if(storageBackupManager == null){
			storageBackupManager = new CloudStorageBackupManager(this);
		}
		return storageBackupManager;
	}
	
	public CloudEndpoint getEndpoint(){
		return getRegion().getEndpoint();
	}
}
