/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.plugin.monitor;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.monitor.action.DeleteInterface;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.plugin.monitor.IMonitorPlugin;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;

public class BillingMonitor implements IMonitorPlugin {
	private static MessageManager messages = MessageManager.getInstance("messages");
	
	public static final String monitorPluginId = "MON_BILLING";
	private static final int monitorCode = 251;
	public static final String monitorName = messages.getString("word.monitor_cloud_billing");
	private static final int monitorType = IMonitorPlugin.MONITOR_TYPE_NUMERIC;

	@Override
	public String getMonitorPluginId() {
		return monitorPluginId;
	}

	@Override
	public int getMonitorCode() {
		return monitorCode;
	}

	@Override
	public String getMonitorName() {
		return monitorName;
	}

	@Override
	public int getMonitorType() {
		return monitorType;
	}

	@Override
	public int create(Shell shell, String monitorId, boolean updateFlg) {
		CreateBillingMonitorDialog dialog = new CreateBillingMonitorDialog(shell, monitorId, updateFlg);
		return dialog.open();
	}

	@Override
	public DeleteInterface getDeleteMonitorClassObject() {
		return new DeleteMonitor();
	}

	public static class DeleteMonitor implements DeleteInterface {
		@Override
		public boolean delete(String monitorId) throws Exception{
	
			boolean result = false;
			try {
				result = MonitorSettingEndpointWrapper.deleteMonitor(monitorId, monitorPluginId);
			} catch (MonitorNotFound_Exception e) {
				String[] msgArgs = { monitorId };
				MessageDialog.openInformation(
						null,
						Messages.getString("message"),
						Messages.getString("message.monitor.notfound", msgArgs));
			}
			return result;
		}
	}
}
